
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include <sys/types.h>
#include <unistd.h>


struct parameter_spec;
struct type_spec;
struct signal_spec;
struct signal_block_start;

void print_param_list_names(FILE *out, parameter_spec *p);
void print_param_list_both(FILE *out, parameter_spec *p);
void print_param_list_types(FILE *out, parameter_spec *p);
char *signal_func(FILE *out,char *c,char*n); 
char *signal_func1(FILE *out, char *c,char *n);
void checkchar(char *s, char c);
char *parseparam(char *s, parameter_spec **p);
char *parsename(char *s, char **name);
char *parsesignal(char *s, signal_spec **spec);
char *parsetype(char *s, type_spec *spec);
void parse_error(char *err,char *rest);
void generate_signal_object1(FILE *out, signal_spec *p, signal_block_start *bs);
void printfromtemplate(FILE *out, char *format, char **replacelist);
extern "C" {
    char *strdup(const char *);
    char *basename(const char *);
}
char *parameter_count(parameter_spec *p);
char *get_arg_types(parameter_spec *p);
char *get_arg_both(parameter_spec *p);
char *get_arg_names(parameter_spec *p);

int pid;
static char *source;

//
// Parser data structures!
//


struct parser_keywords {
    char *name;
    char *(*function)(char *b,char *n);
};

struct signal_block_start {
public:
    char *uname;
    char *lname;
    char *base;
    struct signal_spec *first;
    signal_block_start() : uname(0), lname(0), base(0), first(0) { }
};

struct type_spec {
    char *name;
};

struct parameter_spec {
    type_spec type;
    parameter_spec *next;
};

struct signal_spec {
    type_spec rettype;
    signal_spec *next;
    parameter_spec *firstparameter;
    char *funcname;
    signal_spec() : next(0), firstparameter(0), funcname(0) { }
};

signal_block_start currentblock;

FILE *out;
FILE *out2;
FILE *out3;

FILE *safe_fopen (const char *p, char *n)
{
  char b[1000];
  sprintf (b,"%s%d", p, pid);
  return fopen (b, n);
}


//
// Parser functions
//

char *signalspec_func(char *,char *c) {  
    signal_spec **spec=&currentblock.first;
    while(*spec&&(*spec)->next) {
	spec=&(*spec)->next;
    }
    if (*spec) spec=&(*spec)->next;
    checkchar(c++,'(');
    c=parsesignal(c,spec);
    checkchar(c++,')');
    //fprintf(stderr,"SIGNAL_PARSED: %s\n",(*spec)->funcname);
    generate_signal_object1(out,*spec,&currentblock);
    return c;
}


char *signalstart_func(char *, char *c) {
    currentblock.first=0; // mem leak.
    checkchar(c++,'(');
    c=parsename(c,&currentblock.uname);
    checkchar(c++,',');
    c=parsename(c,&currentblock.base);
    checkchar(c++,')');

    // the next one converts CheckButton to check_button, and HRuler to hruler
    currentblock.lname=(char*)malloc(strlen(currentblock.uname)+1+15);
    char *tmp1=currentblock.uname;
    char *tmp2=currentblock.lname;
    while(*tmp1) {
	if (isupper(*tmp1)&&tmp1!=currentblock.uname&&tmp1!=currentblock.uname+1) { *tmp2='_'; tmp2++; }
	*tmp2=tolower(*tmp1);
	tmp1++; tmp2++;
    }
    *tmp2=0; // null terminate
    //strcpy(currentblock.lname,currentblock.uname);
    return c;
}

char *class_start_func(char *, char *c) {
    fclose(out);
    out=safe_fopen(".gtkmmheader1","w");
    return c;
}
char *impl_start_func(char *, char *c) {
    fprintf(out,"#endif\n");
    fclose(out);
    out=safe_fopen(".gtkmmsource1","w");
    return c;
}

char *signalend_func(char *, char *c) {
    checkchar(c++,'(');
    checkchar(c++,')');

    char *gentemplate=

	"  struct c_signals_$W : public c_signals_$BASE {\n";
    char *mapping[]={
	"W",currentblock.uname,
	"w",currentblock.lname,
	"BASE", currentblock.base,
	(char*)0,(char*)0};
    printfromtemplate(out3,gentemplate,mapping);

    signal_spec *p=currentblock.first;
    for(;p;p=p->next) {
	char *mapping[]={
	    "W",currentblock.uname,
	    "w",currentblock.lname,
	    "NUM",parameter_count(p->firstparameter),    
	    "RETTYPE",p->rettype.name,
	    "ARGTYPES", get_arg_types(p->firstparameter),   
	    "NAME", p->funcname, 
	    "DOT", (p->firstparameter?",":""),
	    "ARGBOTH", get_arg_both(p->firstparameter),
	    "ARGNAMES", get_arg_names(p->firstparameter),
	    "RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"",
	    "RETURN", (strcmp(p->rettype.name,"void"))?"return":"",
	    (char*)0,(char*)0};
	char *gentemplate=
	    "    $RETTYPE (*$NAME)(Gtk$W*$DOT$ARGTYPES);\n";
	printfromtemplate(out3,gentemplate,mapping);
  

    }

    char *gentt=
	"  };\n";
    printfromtemplate(out3,gentt,mapping);
  

    char *gent2=
	//      "    Gtk_Class_Proxy_$W::Gtk_Class_Proxy_$W(char *this_class_name, guint (*type_func_ptr)())\n"
	//"    : name(this_class_name), get_type_func_ptr(type_func_ptr) {\n"
	//"       printf(\"Initializing: %s, %p\\n\",this_class_name,type_func_ptr); "
	//"    }\n"
	"    guint Gtk_Class_Proxy_$W::get_type() {\n"
	"      static guint type=0;\n"
	"      if (!type) {\n"
	"      GtkTypeInfo info = {\n"
	"        name, sizeof(proxy_Object), sizeof(proxy_Class),\n"
	"        (GtkClassInitFunc) class_init_function,\n"
	"        (GtkObjectInitFunc) object_init_function,\n"
	"        (GtkArgSetFunc) NULL,\n"
	"        (GtkArgGetFunc) NULL\n"
	"        };\n"
	"        type=gtk_type_unique(get_type_func_ptr(), &info);\n"
	"      }\n"
	"    return type;\n"
	"    }\n"
	"  c_signals_Base *Gtk_$W::internal_getsignalbase() {\n"
	"  c_signals_$W *tmp=&((Gtk_Class_Proxy_$W::proxy_Class*)GTK_OBJECT_CLASS(gtkobject->klass))->sigs; "
	"  return tmp;\n"
	"  }\n"
	"    void Gtk_Class_Proxy_$W::class_init_function(Gtk_Class_Proxy_$W::proxy_Class *p) {\n"
	"      CppObjectType::cpp_class_init(&p->parent_class,&p->sigs);\n"
	"    }\n"
	"    void Gtk_Class_Proxy_$W::object_init_function(Gtk_Class_Proxy_$W::proxy_Object *) {\n"
	"    }\n"
	;

    printfromtemplate(out2,gent2,mapping);
      

    char *gent3=
	"  class Gtk_$W;\n"
	"  class Gtk_Class_Proxy_$W {\n"
	"  public:\n"
	"    typedef Gtk_$W CppObjectType;\n"
	"    typedef Gtk$W BaseObjectType;\n"
	"    typedef Gtk$WClass BaseClassType;\n"
	//      "    Gtk_Class_Proxy_$W(char *this_class_name, guint (*type_func_ptr)());\n"
	//      "    : name(this_class_name), get_type_func_ptr(type_func_ptr) {\n"
	//      "       printf(\"Initializing: %s, %p\\n\",this_class_name,type_func_ptr); "
	//      "    }\n"
 	"    struct proxy_Object {\n"
	"      BaseObjectType object;\n"
	"    };\n"
	"    struct proxy_Class {\n"
	"      BaseClassType parent_class;\n"
	"      c_signals_$W sigs;\n"
	"    };\n"
	"    static void class_init_function(proxy_Class *p);\n"
	"    static void object_init_function(proxy_Object *);\n"
	"    guint get_type();\n"
	"    char *name;\n"
	"    guint (*get_type_func_ptr)();\n"
	"  };\n"
	;

    printfromtemplate(out3,gent3,mapping);


    char *genextra=
	"Gtk_Class_Proxy_$W Gtk_$W::c_class={\"Gtk_$W\",gtk_$w_get_type};\n";

    printfromtemplate(out2,genextra,mapping);

    char *gent1=
	"\n"
	"  typedef Gtk$W BaseObjectType;\n"
	//   "  static Gtk_Class_Proxy<$CPP, $C, $OBJ> c_class;\n"
	"  static Gtk_Class_Proxy_$W c_class; \n"

	"  virtual c_signals_Base *internal_getsignalbase();\n"
	"  static void cpp_class_init(Gtk$WClass *o,c_signals_$W *s) {\n"
	"    Gtk_$BASE::cpp_class_init((Gtk$BASEClass *)o,s);\n";
    printfromtemplate(out,gent1,mapping);

    p=currentblock.first;
    for(;p;p=p->next) {
	char *mapping[]={
	    "W",currentblock.uname,
	    "w",currentblock.lname,
	    "NUM",parameter_count(p->firstparameter),    
	    "RETTYPE",p->rettype.name,
	    "ARGTYPES", get_arg_types(p->firstparameter),   
	    "NAME", p->funcname, 
	    "DOT", (p->firstparameter?",":""),
	    "ARGBOTH", get_arg_both(p->firstparameter),
	    "ARGNAMES", get_arg_names(p->firstparameter),
	    "RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"",
	    "RETURN", (strcmp(p->rettype.name,"void"))?"return":"",
	    (char*)0,(char*)0};
	char *gent2=
	    "    s->$NAME=o->$NAME;\n"
            "    o->$NAME=$NAME_callback;\n";

	printfromtemplate(out,gent2,mapping);
    }
    fprintf(out,"  }\n");

    return c;
}


void checkchar(char *s, char c) {
    if (*s!=c) { 
	parse_error("checkchar failed.",s);
	fprintf(stderr,"at char '%c'\n",c);
    }
}


char *parseparam(char *s, parameter_spec **p) {
    *p=new parameter_spec;
    (*p)->next=0;
    switch(*s++) {
    case ')': // end of param list.
	delete *p;
	*p=0;
	s--;
	break;
    case ',': // next param
    case '(': // start of param list
	if (*s==')') { delete *p; *p=0; break; }
	s=parsetype(s,&(*p)->type);
	{   
	    char *c=(*p)->type.name;
	    for(;*c;c++) if (*c=='_') *c=' '; // convert all _'s to spaces
	}
	s=parseparam(s,&(*p)->next);
	break;
    default:
	parse_error("Parseparam expected '(', ')' or ','",s);
    }
    //fprintf(stderr,"PARAM Parsed\n");
    return s;
}

char *parsename(char *s, char **name) {
    int l1=strspn(s," ");
    s+=l1;
    int l=strcspn(s," (),");
    if (!l) {
	parse_error("Expected ' ', '(' or ')'",s);
    }
    char *n=new char[l+1];
    *n=0;
    strncpy(n,s,l);
    n[l]=0;
    *name=n;
    //fprintf(stderr,"NAME Parsed\n");
    return s+l;
}



char *parsesignal(char *s, signal_spec **spec) {
    *spec=new signal_spec;
    s=parsetype(s,&(*spec)->rettype);
    checkchar(s++,' ');
    s=parsename(s,&(*spec)->funcname);
    checkchar(s,'(');
    s=parseparam(s,&(*spec)->firstparameter);
    checkchar(s++,')');
    //fprintf(stderr,"SIGNAL Parsed\n");
    return s;
}

// cannot have spaces or ,'s inside type.
// this cannot read  void(*)()'s.
char *parsetype(char *s, type_spec *spec) {
    int l=strcspn(s,"), ");
    char *tname=new char[l+1];
    *tname=0;
    strncpy(tname,s,l);
    tname[l]=0;
    spec->name=tname;
    //fprintf(stderr,"TYPE Parsed\n");
    return s+l;
}

//
// Code generation functions
//

int parameter_count_num(parameter_spec *p) {
    if (!p) return 0;
    return 1+parameter_count_num(p->next);
}

char *parameter_count(parameter_spec *p) {
    char *t=(char*)malloc(2);
    t[0]="0123456789"[parameter_count_num(p)];
    t[1]=0;
    return t;
}



/*
void print_param_list_types(FILE *out, parameter_spec *p) {
  while(p) {
    fprintf(out,"%s",p->type.name);
    p=p->next;
    if (p) fprintf(out,",");
  }
}
*/
char *get_arg_types(parameter_spec *p) {
    char *c=(char*)malloc(2);
    *c=0;
    while(p) {
	char *c1=(char*)malloc(strlen(c)+strlen(p->type.name)+1+1+1);
	strcpy(c1,c);
	strcat(c1,p->type.name);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
    }
    return c;
}

char *get_arg_both(parameter_spec *p) {
    char *c=(char*)malloc(2);
    *c=0;
    char *pp=(char*)malloc(4);
    pp[0]=' '; pp[1]='p'; pp[3]=0;
    int count=0;
    while(p) {
	char *c1=(char*)malloc(strlen(c)+strlen(p->type.name)+6);
	strcpy(c1,c);
	strcat(c1,p->type.name);
	pp[2]="1234567890"[count];
	strcat(c1,pp);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
	count++;
    }
    return c;
}

char *get_arg_names(parameter_spec *p) {
    char *c=(char*)malloc(2);
    *c=0;
    char *pp=(char*)malloc(3);
    pp[0]='p'; pp[2]=0;
    int count=0;
    while(p) {
	char *c1=(char*)malloc(strlen(c)+1+2+1+1);
	strcpy(c1,c);
	pp[1]="1234567890"[count];
	strcat(c1,pp);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
	count++;
    }
    return c;
}


/*
void print_param_list_names(FILE *out, parameter_spec *p) {
  int count=1;
  while(p) {
    fprintf(out,"p%d",count);
    p=p->next;
    count++;
    if (p) fprintf(out,",");
  }
}

void print_param_list_both(FILE *out, parameter_spec *p) {
  int count=1;
  while(p) {
    fprintf(out,"%s p%d",p->type.name,count);
    p=p->next;
    count++;
    if (p) fprintf(out,",");
  }
}
*/
/*
  static int argcount;
  void count(parameter_spec *p) { argcount++; }
  */
//
// Use this function like this:
// char *repl[]={"NAME","DATA",
//               "FOO","D1",
//               "FOO2","D3",
//                0,0};
// char *source="djkfghdkjhgdjghjk $NAME$FOO$FOO2"
// printfromtemplate(source,repl); will print
// "djkfghdkjhgdjghjk DATAD1D12"
//
void printfromtemplate(FILE *out, char *format, char **replacelist) {
    char *f=strdup(format);
    char *f1=f;

    char *t;
    while((t=strchr(f,'$'))) {
	// output part before $
	*t=0;
	fprintf(out,"%s",f);
	*t='$';

	// check if we have a match
	char **repllist=replacelist;
	while(*repllist&&strncmp(*repllist,t+1,strlen(*repllist))) repllist+=2;
	if (*repllist) {
	    // we do. print replacement
	    fprintf(out,"%s",repllist[1]);
	    f=t+strlen(repllist[0])+1;
	} else {
	    fprintf(out,"$");
	    f++;
	}
    }
    fprintf(out,"%s",f); // print rest.
    free(f1);
}


void generate_signal_object1(FILE *out, signal_spec *p, signal_block_start *bs) {

    char *genheader=
	"  Signal_proxy$NUM<$RETTYPE,Gtk_$W$DOT$ARGTYPES> $NAME;\n"
	"protected:\n"
	"  virtual $RETTYPE $NAME_impl($ARGBOTH);\n"
	"public:\n"
	"  static $RETTYPE $NAME_callback(Gtk$W *o$DOT$ARGBOTH);\n"
	;

    char *gentemplate=
	"  $RETTYPE Gtk_$W::$NAME_impl($ARGBOTH) {\n"
	"    c_signals_$W *sig=(c_signals_$W *)internal_getsignalbase();\n"
	"    if (!sig->$NAME) $RETURN_0;\n"
	"    $RETURN sig->$NAME(gtkobj()$DOT$ARGNAMES);\n"
	"  }\n"
	"  $RETTYPE Gtk_$W::$NAME_callback(Gtk$W *o$DOT$ARGBOTH) {\n"
	"    Gtk_$W *obj=(Gtk_$W *)gtk_object_get_data(GTK_OBJECT(o),\"cpp\");\n"
	"    if (obj) {\n"
	"      $RETURN obj->$NAME_impl($ARGNAMES);\n"
	" }\n"
	//    "    } else {\n"
	//    "      printf(\"Error, C++ signal handler called by C object (Gtk_$W::$NAME)\\n\");\n"
	"      $RETURN_0;\n"
	//    "    }\n"
	"  }\n";

    char *mapping[]={
	"NUM",parameter_count(p->firstparameter),    
	"RETTYPE",p->rettype.name,
	//    "CLASS",bs->cppobjname,  
	"ARGTYPES", get_arg_types(p->firstparameter),   
	"NAME", p->funcname, 
	"DOT", (p->firstparameter?",":""),
	"ARGBOTH", get_arg_both(p->firstparameter),
	"ARGNAMES", get_arg_names(p->firstparameter),
	"RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"return",
	"RETURN", (strcmp(p->rettype.name,"void"))?"return":"",
	"W",currentblock.uname,
	"w",currentblock.lname,

	(char*)0,(char*)0};

    printfromtemplate(out2,gentemplate,mapping);
    printfromtemplate(out,genheader,mapping);
 
}




struct parser_keywords keywords[]={
    {"SIGNAL_START",signalstart_func},
    {"SIGNAL_SPEC",signalspec_func},
    {"SIGNAL_END",signalend_func},
    {"CLASS_START",class_start_func},
    {"IMPL_START", impl_start_func},
    {0,0}
};

static int linenum=1;
void parser(FILE *infile) {  
    char buf[180];
    while(fgets(buf,180,infile)) {
	char *sbuf=buf;
	while(sbuf) {
	    parser_keywords *p=keywords;
	    while(p->name) {
		char *t=strstr(sbuf,p->name);
		if (t) {
		    sbuf=(p->function)(t,t+strlen(p->name));
		    checkchar(sbuf++,';');
		    fprintf (out,"#line %d \"%s\"\n", linenum, source);
		    goto nextfind;
		}
		p++;
	    }
	    // default action is to print the line as it is and read next.
	    fprintf(out,"%s",sbuf);
	    sbuf=0;
	nextfind:;
	} 
	linenum++;
    }
    //fprintf(stderr,"FILE Parsed\n");

}

void parse_error(char *err,char *rest) {
    fprintf(stderr,"%d : Parse error %s\nAt: -%s\n",linenum,err,rest);
    char *a=0;
    *a=10; // sigsegv
}

void usage(char *argv0, char *reason) {
    printf("%s\n",reason);
    printf("Usage: %s [-h] [-l] source dest\n",argv0);
    printf("    -h = help\n");
    printf("    -l = generate local files -- use this flag for non-gtk-- widgets\n");
    printf("\nNote: This will read source.gen_h file and generates dest.cc dest.h files.\n");
    exit(EXIT_FAILURE);
}

int main(int argc,char *argv[]) {
    FILE *in;
    int i=1,local=0;
    char buf[1024],genname[240],error[240],*target_basename,*target;

    while ((i<argc)&&(argv[i][0]=='-'))
      {switch (argv[i][1])
         {case 'h': /* version */
            usage(argv[0],"");
          case 'l': /* local */
            local=1;
            break;
          default:
            printf("Unknown option %s\n",argv[i]);
         }
       i++;
      } 

    if (argc-i==2) {
        source=argv[i];
        target=argv[i+1]; 
	target_basename = basename(target);
	strcpy(genname,source);
	in=fopen(source,"r");
	if (!in) {
	    sprintf(error,"Cannot open file %s.",source);
	    usage(argv[0],error);
	}
    } else {
	usage(argv[0],"Invalid number of arguments.");
    }
    pid = getpid();
    
    out=safe_fopen(".gtkmmheader","w");
    out2=safe_fopen(".gtkmmsource","w");
    out3=safe_fopen(".gtkmmextraheader","w");

    fprintf(out,"/*\n");
    fprintf(out,"   This file has been generated by gtksig from %s. DO NOT MODIFY!!!\n",genname);
    fprintf(out,"*/\n");

    fprintf(out2,"/*\n");
    fprintf(out2,"   This file has been generated by gtksig from %s. DO NOT MODIFY!!!\n",genname);
    fprintf(out2,"*/\n");
    if (!local)
      fprintf(out2,"#include <gtk--/%s.h>\n",target_basename);
     else
      fprintf(out2,"#include \"%s.h\"\n",target_basename);
    fprintf(out,"#ifndef GTKMM_%s_HEADER\n#define GTKMM_%s_HEADER\n",target_basename,target_basename);


    parser(in);
    fclose(out3);
    fclose(out2);
    fclose(out);

    sprintf(buf,"cat .gtkmmheader%d .gtkmmextraheader%d .gtkmmheader1%d >%s.h",
	    pid,pid,pid,target);
    system(buf);

    sprintf(buf,"cat .gtkmmsource%d .gtkmmsource1%d >%s.cc",pid,pid,target);
    system(buf);
    sprintf(buf,"rm .gtkmmextraheader%d .gtkmmheader%d .gtkmmheader1%d .gtkmmsource1%d .gtkmmsource%d",pid,pid,pid,pid,pid);
    system(buf);
    return 0;
}
