/* Codes returned by the GNATS server.
   Copyright (C) 1994, 95, 96, 1997 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

/* The information we need for a reply from the server.  */
typedef struct _reply
{
  int state;
  char *text;
  int type;
} Reply;

typedef enum _msg_type {
  PR_eof, PR_ok, PR_long, PR_timeout
} MsgType;

/* in gnatsd.c */
extern MsgType get_line			PARAMS((char *, int, int));

/* cmds.c */
extern void GNATS_helo			PARAMS((int, char**));
extern void GNATS_quit			PARAMS((int, char**));
extern void GNATS_qury			PARAMS((int, char**));
extern void GNATS_summ			PARAMS((int, char**));
extern void GNATS_sqlf			PARAMS((int, char**));
extern void GNATS_full			PARAMS((int, char**));
extern void GNATS_lock			PARAMS((int, char**));
extern void GNATS_unlk			PARAMS((int, char**));
extern void GNATS_lkdb			PARAMS((int, char**));
extern void GNATS_undb			PARAMS((int, char**));
extern void GNATS_edit			PARAMS((int, char**));
extern void GNATS_mlpr			PARAMS((int, char**));
extern void GNATS_mlct			PARAMS((int, char**));
extern void GNATS_mlsu			PARAMS((int, char**));
extern void GNATS_type			PARAMS((int, char**));
extern void GNATS_resp			PARAMS((int, char**));
extern void GNATS_catg			PARAMS((int, char**));
extern void GNATS_synp			PARAMS((int, char**));
extern void GNATS_conf			PARAMS((int, char**));
extern void GNATS_svty			PARAMS((int, char**));
extern void GNATS_stat			PARAMS((int, char**));
extern void GNATS_sear			PARAMS((int, char**));
extern void GNATS_msrc			PARAMS((int, char**));
extern void GNATS_clss			PARAMS((int, char**));
extern void GNATS_rlse			PARAMS((int, char**));
extern void GNATS_abfr			PARAMS((int, char**));
extern void GNATS_araf			PARAMS((int, char**));
extern void GNATS_vdat			PARAMS((int, char**));
extern void GNATS_orig			PARAMS((int, char**));
extern void GNATS_prio			PARAMS((int, char**));
#ifdef GNATS_RELEASE_BASED
extern void GNATS_bfor			PARAMS((int, char**));
extern void GNATS_aftr			PARAMS((int, char**));
#endif
extern void GNATS_vdat			PARAMS((int, char**));
extern void GNATS_subm			PARAMS((int, char**));
extern void GNATS_text			PARAMS((int, char**));
extern void GNATS_mtxt			PARAMS((int, char**));
extern void GNATS_rset			PARAMS((int, char**));
extern void GNATS_auth			PARAMS((int, char**));
extern void GNATS_lcat			PARAMS((int, char**));
extern void GNATS_lres			PARAMS((int, char**));
extern void GNATS_lsub			PARAMS((int, char**));
extern void GNATS_load			PARAMS((int, char**));
extern void GNATS_chst			PARAMS((int, char**));
extern void GNATS_chre			PARAMS((int, char**));
extern void GNATS_chor			PARAMS((int, char**));
extern void GNATS_chsu			PARAMS((int, char**));
extern void GNATS_chsy			PARAMS((int, char**));
extern void GNATS_chco			PARAMS((int, char**));
extern void GNATS_chse			PARAMS((int, char**));
extern void GNATS_chpr			PARAMS((int, char**));
extern void GNATS_chct			PARAMS((int, char**));
extern void GNATS_chrl			PARAMS((int, char**));
extern void GNATS_chcl			PARAMS((int, char**));
extern void GNATS_nocl			PARAMS((int, char**));
extern void GNATS_help			PARAMS((int, char**));
#ifdef GNATS_RELEASE_BASED
extern void GNATS_qrtr			PARAMS((int, char**));
extern void GNATS_kywd			PARAMS((int, char**));
#endif

#include <netinet/in.h> /* for sockaddr_in */
#include <arpa/inet.h>	/* for inet_ntoa decl */
#include <sys/param.h>
#include <netdb.h>	/* for hostent and MAXHOSTNAMELEN */
#include <sys/socket.h>	/* for AF_INET */
#include <sys/time.h>	/* for timeval */
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>	/* for fd_set */
#endif

/* Whether we received `STATE-' or `STATE '.  */
#define REPLY_CONT	1
#define REPLY_END	2

/* Used if Kerberos version 4 authentication is enabled.  */
#define GNATS_KRB4_VERSIONID		"GnatsK1.0"
#define GNATS_KRB4_PRINCIPAL_NAME	gnats_user

#include "pcodes.h"
