#ifndef _byteorder_h
#define _byteorder_h

#include <endian.h>
#include <asm/byteorder.h>

/* 2.0.x kernel headers only define ntoh/hton stuff, not __cpu_to_le32 etc. */
#ifndef __cpu_to_le32
#if (__BYTE_ORDER == __LITTLE_ENDIAN)
#define __cpu_to_le32(x)	(x)
#define __le32_to_cpu(x)	(x)
#define __cpu_to_le16(x)	(x)
#define __le16_to_cpu(x)	(x)
#define __cpu_to_be32(x)	htonl((x))
#define __be32_to_cpu(x)	htonl((x))
#define __cpu_to_be16(x)	htons((x))
#define __be16_to_cpu(x)	htons((x))
#else
#define __cpu_to_be32(x)	(x)
#define __be32_to_cpu(x)	(x)
#define __cpu_to_be16(x)	(x)
#define __be16_to_cpu(x)	(x)
#define __cpu_to_le32(x)	htonl((x))
#define __le32_to_cpu(x)	htonl((x))
#define __cpu_to_le16(x)	htons((x))
#define __le16_to_cpu(x)	htons((x))
#endif
#endif

#endif  /* _byteorder_h */

