/***************************************************************************
**    xIrcConnect1.cpp  $Revision: 1.15 $ - $Name: V2-0 $ 
**    Class for making the server connections
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <pwd.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <qapp.h>
#include <qkeycode.h>
#include <qsize.h>
#include <xApp.h>
#include <xLineEditQuery.h>
#include <xMessageBox.h>
#include "xIrcChannelQuery.h"
#include "xIrcMsgDispatch.h"
#include "xIrcNickQuery.h"
#include "xIrcDccQuery.h"
#include "xIrcServerQuery.h"
#include "xIrcErrorBox.h"
#include "xIrcInviteBox.h"
#include "xIrcIgnoreQuery.h"
#include "xDefaults.h"
#include "xIrcConnect.h"

static int dbg = 0;

extern xApplication *pApp;
extern xDefaults Defaults;
extern xIrcNickQuery *NickQuery;
extern xChannelQuery *ChanQuery;
extern xServerQuery *ServQuery;
extern xLineEditQuery *QuitQuery;
extern xIrcCommands ircResponses;
extern QPixmap *AppPixMap;
extern xIrcMsgDispatch Dispatcher;

xIrcConnect::xIrcConnect(xWidgetResInfo *pPRes, QWidget *parent,
                         const char *name, WFlags iFlags,
                         int width, int height, int maxLines) :
              xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("main"),
                                                  QString("Main")),
                      parent, name, 0)
{
   struct passwd *pPasswdEnt;
   char buf[80];

   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Enter\n");
   if (dbg) fflush(stdout);
   wdtPrv = new xWidgetResInfo(pPRes);
   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Settingv colors\n");
   if (dbg) fflush(stdout);
   setDefPallet(this, wdtRes);
   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Setting fonts\n");
   if (dbg) fflush(stdout);
   setDefFont(this, wdtRes);
   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Setting Popup ResInfo\n");
   if (dbg) fflush(stdout);

   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Initializing Variables\n");
   if (dbg) fflush(stdout);
   iFlags = 0;
   resizeCnt = -2;
   quitFlag = FALSE;
   serverFlag = FALSE;
   banFlag = FALSE;
   ignoreFlag = FALSE;
   pIrcMsgFrames = NULL;
//   pSocket = new xIrcSocket(this);
   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Setting Socket to Null\n");
   if (dbg) fflush(stdout);
   pSocket = NULL;
   Dispatcher.setSocket(pSocket);

   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Creating Main Window\n");
   if (dbg) fflush(stdout);
   pMainWin = new xMultiLineFrame(wdtRes, this, NULL, width, height, maxLines);
   if (AppPixMap != NULL)
      setIcon(*AppPixMap);
   setAcceptFocus(TRUE);   
   pPasswdEnt = getpwuid(getuid());
   userName = pPasswdEnt->pw_name;
   realName = pPasswdEnt->pw_gecos;
   gethostname(buf, sizeof(buf));
   hostName = buf;

   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Creating SocketBox\n");
   if (dbg) fflush(stdout);
   pSocketBox = new xSocketDialog(wdtPrv, NULL);

   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Creating BanBox\n");
   if (dbg) fflush(stdout);
   pBanBox = new xIrcBanDialog(wdtPrv);
   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Creating NickAction\n");
   if (dbg) fflush(stdout);
   pNickAction = NULL;
   pNickAction = new xIrcNickActionQuery(wdtPrv);

   pIgnore = new xIrcIgnoreQuery(wdtPrv);
   pNotify = new xIrcNotifyQuery(wdtPrv);
   pNotify->shutDown();
   pNotifyList = new xIrcNotifyTable(wdtPrv);

   connect(pNotify, SIGNAL(updateList(xIrcPeopleList*)),
           pNotifyList, SLOT(update(xIrcPeopleList*)));
   pNotifyList->show();

   pLabel = new xLabel(wdtRes, this);

   xWidgetResInfo wdtTmp(wdtRes, QString("menu"), QString("Menu"));
   xWidgetResInfo wdtPopTmp(&wdtTmp, QString("popup"), QString("Popup"));

   pNickMenu = new QPopupMenu;
   setDefFont(pNickMenu, &wdtPopTmp);
   setDefPallet(pNickMenu, &wdtPopTmp);
   pNickMenu->insertItem("Show Folks Online", this, SLOT(showNotifyList()));
   pNickMenu->insertItem("Action", this, SLOT(showNickAction()));
   pNickMenu->insertItem("Change Nick", this, SLOT(newNick()));
   setDefFont(pNickMenu, &wdtPopTmp);
   setDefPallet(pNickMenu, &wdtPopTmp);

   pListMenu = new QPopupMenu;
   setDefFont(pListMenu, &wdtPopTmp);
   setDefPallet(pListMenu, &wdtPopTmp);
   pListMenu->insertItem("Server List", this, SLOT(newServer()));
   pListMenu->insertItem("Ignore List", this, SLOT(showIgnore()));
   pListMenu->insertItem("Notify List", this, SLOT(showNotify()));
   setDefFont(pListMenu, &wdtPopTmp);
   setDefPallet(pListMenu, &wdtPopTmp);

   pFileMenu = new QPopupMenu;
   setDefFont(pFileMenu, &wdtPopTmp);
   setDefPallet(pFileMenu, &wdtPopTmp);
   pFileMenu->insertItem("Connect Server", this, SLOT(newServer()));
   pFileMenu->insertItem("Open Channel", this, SLOT(newChannel()));
   pFileMenu->insertSeparator();
   pFileMenu->insertItem("Exit", this, SLOT(quitIrc()));
   setDefFont(pFileMenu, &wdtPopTmp);
   setDefPallet(pFileMenu, &wdtPopTmp);

   pMenu = new QMenuBar(this);
   setDefFont(pMenu, &wdtPopTmp);
   setDefPallet(pMenu, &wdtPopTmp);
   pMenu->insertItem("File", pFileMenu);
   pMenu->insertItem("Nick", pNickMenu);
   pMenu->insertItem("Lists", pListMenu);
   setDefFont(pMenu, &wdtTmp);
   setDefPallet(pMenu, &wdtTmp);

/*
   pButtons = new xPshBtnFrame(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->setAlignment(xALIGN_Horz);
   pButtons->setResizeMode(xSPACE_Resize);
   pButtons->setWidgetSpacing(2);
   pButtons->setMargins(2, 2);
   pButtons->addButton("Server Selection", btnServer);
   pButtons->addButton("Channels / People", btnChannel);
   pButtons->addButton("Nick Actions", btnAction);
   pButtons->addButton("Your Nick", btnNick);
   pButtons->addButton("Quit", btnQuit);
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(buttonPressed(int)));
*/

   if (dbg) fprintf(stdout, "xIrcConnect::xIrcConnect():Connecting xNickActionQuery Signals/slots\n");
   if (dbg) fflush(stdout);
   connect(pNickAction, SIGNAL(done(xMultiLineTextSelection)), 
          this, SLOT(nickActionHandler(xMultiLineTextSelection)));
   connect(pMainWin, SIGNAL(textSelected(xMultiLineTextSelection)),
           pNickAction, SLOT(wakeUp(xMultiLineTextSelection)));
   connect(pNotifyList, SIGNAL(selected(const char*)),
           pNickAction, SLOT(wakeUp(const char*)));

   connect(ServQuery, SIGNAL(msgToSocket(const char *)),
           this, SLOT(sendMsgToSocket(const char *)));
   connect(ChanQuery, SIGNAL(hasResult(int)),
           this, SLOT(gotChanBoxResult(int)));
   pButtons = NULL;
/*
   connect(pSocket, SIGNAL(socketClosed()),
           this, SLOT(socketClosed()));
   connect(pSocket, SIGNAL(ircServerMessage(xIrcMessage *)),
           this, SLOT(recvMessage(xIrcMessage *)));
   connect(this, SIGNAL(textOut(const char *)), 
           pSocket, SLOT(sendToSocket(const char *)));
   connect(ChanQuery, SIGNAL(ircMessageOut(xIrcMessage*)),
           pSocket, SLOT(sendIrcServerMessage(xIrcMessage*)));
   connect(pSocket, SIGNAL(connecting(const char *)),
           pSocketBox, SLOT(connectMessage(const char *)));
   connect(pSocketBox, SIGNAL(stopConnection()),
           pSocket, SLOT(stopConnect()));
   connect(pSocketBox, SIGNAL(nextConnection()),
           pSocket, SLOT(tryNextConnection()));
   addWidget(pButtons);
*/
   addWidget(pLabel);
   addWidget(pMainWin);
   setMargins(0,0);
   setWidgetSpacing(0);
   initFrame();
}

xIrcConnect::~xIrcConnect() 
{
   xIrcMessageFrame *pM, *pM1;

//   disconnect(this);
   if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Enter\n");
   if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Deleting Socket\n");
   if (dbg) fflush(stdout);
   if (pSocket)
      delete pSocket;
   Dispatcher.setSocket(NULL);
   pNotify->shutDown();
   if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Deleting Buttons\n");
   if (dbg) fflush(stdout);
   if (pButtons)
      delete pButtons;

   if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Nick Action Query\n");
   if (dbg) fflush(stdout);
   if (pNickAction)
      delete pNickAction;

   if (pIrcMsgFrames)
   {
      if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Deleting Message Frames\n");
      if (dbg) fflush(stdout);
      for (pM = pIrcMsgFrames; pM != NULL; pM = pM1)
      {
         if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Pointing to next Message Frame\n");
         if (dbg) fflush(stdout);
         pM1 = pM->next();
         if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Deleting Message Frame\n");
         if (dbg) fflush(stdout);
         delete pM;
      }
   }
   if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Main Window\n");
   if (dbg) fflush(stdout);
   if (pMainWin)
      delete pMainWin;
   if (dbg) fprintf(stdout, "xIrcConnect::~xIrcConnect():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcConnect::showNickAction()
{
   pNickAction->show();
}

void xIrcConnect::showIgnore()
{
   pIgnore->show();
}

void xIrcConnect::showNotify()
{
   pNotify->show();
}

void xIrcConnect::showNotifyList()
{
   if (pNotifyList->isVisible() != TRUE)
      pNotifyList->show();
   else
      pNotifyList->hide();
}

void xIrcConnect::buttonPressed(int btn) 
{
   switch(btn)
   {
      case btnServer:
         newServer();
         break;

      case btnChannel:
         newChannel();
         break;

      case btnAction:
         pNickAction->show();
         break;

      case btnNick:
         newNick();
         break;

      case btnQuit:
         quitIrc();
         break;
   }
}

void xIrcConnect::quitIrc()
{
   char buf[256];
   
   if (QuitQuery->exec() != QDialog::Rejected)
   {
      if (pSocket != NULL)
      {
         if (dbg) fprintf(stdout, "xIrcConnect::quitIrc():Disconnecting from Server\n");
         if (dbg) fflush(stdout);
         sprintf(buf, "QUIT :%s\n", QuitQuery->text());
         emit textOut(buf);
         pSocket->off();
         quitFlag = TRUE;
      }
      else
         pApp->quit();
   }
}

void xIrcConnect::connStatus(int err)
{
   if (err)
      failedConnection(err);
   else
      goodConnection(err);
}

void xIrcConnect::goodConnection(int sock)
{
   const char *pRealName, *pUserName, *pHostName, *cp;
   xIrcMessageFrame *pMsgFrame;
   QString strTmp;
   char buf[256];
   int x;

   if (dbg) fprintf(stdout, "xIrcConnect::goodConnection():Success!!!\n");
   if (dbg) fflush(stdout);
   if (dbg)
   {
      struct sockaddr_in addr;
      addr = pSocket->socketName();

      fprintf(stdout, "xIrcConnect::goodConnection():My IP is:%s (%ld %d)\n",
                      inet_ntoa(addr.sin_addr), 
                      htonl(addr.sin_addr.s_addr), addr.sin_port);
   }
   pSocketBox->connected(QString("Connected: Waiting Response from Host"));
// pMainWin->pWin->putString("Connected!!!\n");

/*
   disconnect(pSocket, SIGNAL(connAccepted(int)),      
              this, SLOT(goodConnection(int)));
   disconnect(pSocket, SIGNAL(connFailed(int)),      
              this, SLOT(failedConnection(int)));
*/
   sprintf(buf, "NICK %s\n", NickQuery->text());

   sock++;
   emit textOut(buf);
   if ((pRealName = Defaults.get("REALNAME")) == NULL)
      pRealName = realName;
   if ((cp = Defaults.get("EMAIL_ADDR")) == NULL)
   {
      pHostName = "dummy.hostname.org";
      pUserName = userName;
   }
   else
   {
      for (strTmp = ""; *cp && *cp != '@'; cp++)
         strTmp += *cp;
      pUserName = strTmp;
      if (*cp)
         pHostName = ++cp;
      else
         pHostName = "dummy.hostname.org";
   }
   sprintf(buf, "USER %s %s %s :%s\n", pUserName, pHostName,
                                      ServQuery->server(), pRealName);
   emit textOut(buf);

   for (x = 0, pMsgFrame = pIrcMsgFrames; pMsgFrame != NULL; pMsgFrame = pMsgFrame->next())
   {
      cp = (char *)pMsgFrame->name();
      if (strlen(cp) > 0 && *cp == '#')
      {
         sprintf(buf, "JOIN %s\n", pMsgFrame->name());
         emit textOut(buf);
      }
   }
   Dispatcher.setSocket(pSocket);
   pNotify->startUp();
}

void xIrcConnect::failedConnection(int err)
{
   char buf[512];

   if (dbg) fprintf(stdout, "IrcConnect::failedConnection():Failed!!!\n");
   if (dbg) fflush(stdout);
   pSocketBox->hide();
   if (dbg) fprintf(stdout, "IrcConnect::failedConnection():Discconecting signals\n");
   if (dbg) fflush(stdout);
/*
   disconnect(pSocket, SIGNAL(connAccepted(int)),      
              this, SLOT(goodConnection(int)));
   disconnect(pSocket, SIGNAL(connFailed(int)),      
              this, SLOT(failedConnection(int)));
*/
   disconnect(pSocket, SIGNAL(socketClosed()),
           this, SLOT(socketClosed()));
   disconnect(pSocket, SIGNAL(ircServerMessage(xIrcMessage *)),
           this, SLOT(recvMessage(xIrcMessage *)));
   disconnect(this, SIGNAL(textOut(const char *)), 
           pSocket, SLOT(sendToSocket(const char *)));
   disconnect(this, SIGNAL(msgOut(xIrcMessage *)), 
           pSocket, SLOT(sendIrcServerMessage(xIrcMessage *)));
   disconnect(ChanQuery, SIGNAL(ircMessageOut(xIrcMessage*)),
           pSocket, SLOT(sendIrcServerMessage(xIrcMessage*)));
   disconnect(pSocketBox, SIGNAL(stopConnection()),
           this, SLOT(stopConnection()));
/*
   disconnect(pSocket, SIGNAL(connecting(const char *)),
           pSocketBox, SLOT(connectMessage(const char *)));
   disconnect(pSocketBox, SIGNAL(nextConnection()),
           pSocket, SLOT(tryNextConnection()));
*/
   if (dbg) fprintf(stdout, "IrcConnect::failedConnection():Showing Error\n");
   if (dbg) fflush(stdout);
   sprintf(buf, "***\x02 Connection Failed: %s\n", strerror(err));
   pMainWin->pWin->putString(buf);
//   xMessageBox::message("Error", buf);
   delete pSocket;
   pSocket = NULL;
   Dispatcher.setSocket(pSocket);
   pNotify->shutDown();
//   if (dbg) fprintf(stdout, "IrcConnect::failedConnection():Calling newServer\n");
//   if (dbg) fflush(stdout);
//   newServer();
}

void xIrcConnect::newServer()
{
   int btn, err;
   char buf[512];

   if (dbg) fprintf(stdout, "xIrcConnect::newServer():Enter\n");
   if (dbg) fflush(stdout);
   if ((btn = ServQuery->exec()) != QDialog::Rejected)
   {
      if (pSocket != NULL && (btn == xServerQuery::Disconnect ||
                                      btn == xServerQuery::Accepted))
      {
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():Disconnecting from Current Socket\n");
         if (dbg) fflush(stdout);
         sprintf(buf, "QUIT :Changing Servers\n");
         emit textOut(buf);
         disconnect(pSocket, SIGNAL(socketClosed()),
                 this, SLOT(socketClosed()));
         disconnect(pSocket, SIGNAL(ircServerMessage(xIrcMessage *)),
                 this, SLOT(recvMessage(xIrcMessage *)));
/*
         disconnect(this, SIGNAL(textOut(const char *)), 
                 pSocket, SLOT(sendToSocket(const char *)));
         disconnect(this, SIGNAL(msgOut(xIrcMessage *)), 
                 pSocket, SLOT(sendIrcServerMessage(xIrcMessage *)));
         disconnect(ChanQuery, SIGNAL(ircMessageOut(xIrcMessage*)),
                 pSocket, SLOT(sendIrcServerMessage(xIrcMessage*)));
         disconnect(pSocketBox, SIGNAL(stopConnection()),
                 pSocket, SLOT(stopConnect()));
*/
/*
         disconnect(pSocket, SIGNAL(connecting(const char *)),
                 pSocketBox, SLOT(connectMessage(const char *)));
         disconnect(pSocketBox, SIGNAL(nextConnection()),
                 pSocket, SLOT(tryNextConnection()));
*/
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():Disconnection done\n");
         if (dbg) fflush(stdout);
      }
      if (btn == xServerQuery::Accepted)
      {
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():Creating new socket\n");
         if (dbg) fflush(stdout);
         pSocket = new xIrcSocket(wdtPrv, this,
                                  ServQuery->server(), ServQuery->port(),
                                  pSocketBox, SLOT(connStatus(int)),
                                  SLOT(connectMessage(const char *)), err);
         Dispatcher.setSocket(NULL);
         pNotify->shutDown();
         if (err == 0)
         {
            connect(pSocket, SIGNAL(socketClosed()),
                    this, SLOT(socketClosed()));
            connect(pSocket, SIGNAL(ircServerMessage(xIrcMessage *)),
                    this, SLOT(recvMessage(xIrcMessage *)));
            connect(this, SIGNAL(textOut(const char *)), 
                    pSocket, SLOT(sendToSocket(const char *)));
            connect(this, SIGNAL(msgOut(xIrcMessage *)), 
                    pSocket, SLOT(sendIrcServerMessage(xIrcMessage *)));
            connect(ChanQuery, SIGNAL(ircMessageOut(xIrcMessage*)),
                    pSocket, SLOT(sendIrcServerMessage(xIrcMessage*)));
            connect(pSocketBox, SIGNAL(stopConnection()),
                    this, SLOT(stopConnection()));
         }
/*
         connect(pSocket, SIGNAL(connecting(const char *)),
                 pSocketBox, SLOT(connectMessage(const char *)));
         connect(pSocketBox, SIGNAL(stopConnection()),
                 pSocket, SLOT(stopConnect()));
         connect(pSocketBox, SIGNAL(nextConnection()),
                 pSocket, SLOT(tryNextConnection()));

         connect(pSocket, SIGNAL(connAccepted(int)),      
                 this, SLOT(goodConnection(int)));
         connect(pSocket, SIGNAL(connFailed(int)),      
                 this, SLOT(failedConnection(int)));
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():calling xSocket::connectTo\n");
         if (dbg) fflush(stdout);
         if (pSocket->connectTo(ServQuery->server(), ServQuery->port()) == FALSE)
*/
         else
         {
            if (dbg) fprintf(stdout, "xIrcConnect::newServer():Got an error\n");
            if (dbg) fflush(stdout);
/*
            disconnect(pSocket, SIGNAL(connAccepted(int)),      
                       this, SLOT(goodConnection(int)));
            disconnect(pSocket, SIGNAL(connFailed(int)),      
                       this, SLOT(failedConnection(int)));
            pSocketBox->hide();
            xMessageBox::message("Error", "Connection Failed");
*/
            if (dbg) fprintf(stdout, "xIrcConnect::newServer():Failed!!!\n");
            if (dbg) fflush(stdout);
            delete pSocket;
            pSocket = NULL;
            Dispatcher.setSocket(pSocket);
            pNotify->shutDown();
            newServer();
         }
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():Waiting connection\n");
         if (dbg) fflush(stdout);
      }
      else
      {
         pSocket = NULL;
         Dispatcher.setSocket(pSocket);
         pNotify->shutDown();
      }
   }
}

void xIrcConnect::newNick()
{
   char buf[256];

   for (;;)
   {
      if (NickQuery->exec() != QDialog::Rejected)
      {
         nickName = NickQuery->text();
         sprintf(buf, "NICK %s\n", NickQuery->text());
         emit textOut(buf);
         break;
      }
      else if (strlen(nickName) == 0)
         xMessageBox::message("Error", "You must choose a NickName");
      else
         break;
   }
} 

void xIrcConnect::stopConnection()
{
   
   disconnect(pSocket, SIGNAL(socketClosed()),
              this, SLOT(socketClosed()));
   disconnect(pSocket, SIGNAL(ircServerMessage(xIrcMessage *)),
              this, SLOT(recvMessage(xIrcMessage *)));
   disconnect(this, SIGNAL(textOut(const char *)), 
              pSocket, SLOT(sendToSocket(const char *)));
   disconnect(this, SIGNAL(msgOut(xIrcMessage *)), 
              pSocket, SLOT(sendIrcServerMessage(xIrcMessage *)));
   disconnect(ChanQuery, SIGNAL(ircMessageOut(xIrcMessage*)),
              pSocket, SLOT(sendIrcServerMessage(xIrcMessage*)));
   disconnect(pSocketBox, SIGNAL(stopConnection()),
              this, SLOT(stopConnection()));
   pSocket->stopConnect();
   delete pSocket;
   pSocket = NULL;
   Dispatcher.setSocket(pSocket);
   pNotify->shutDown();
}

void xIrcConnect::socketClosed()
{
      char buf[512];

      if (dbg) fprintf(stdout, "xIrcConnect::socketClosed():Enter\n");
      if (dbg) fflush(stdout);
      serverFlag = FALSE;
      if (dbg) fprintf(stdout, "xIrcConnect::socketClosed():Disconnecting signals\n");
      if (dbg) fflush(stdout);
/*
      disconnect(pSocket, SIGNAL(connAccepted(int)),      
                 this, SLOT(goodConnection(int)));
      disconnect(pSocket, SIGNAL(connFailed(int)),      
                 this, SLOT(failedConnection(int)));
*/
      disconnect(pSocket, SIGNAL(socketClosed()),
              this, SLOT(socketClosed()));
      disconnect(pSocket, SIGNAL(ircServerMessage(xIrcMessage *)),
              this, SLOT(recvMessage(xIrcMessage *)));
      disconnect(this, SIGNAL(textOut(const char *)), 
              pSocket, SLOT(sendToSocket(const char *)));
      disconnect(this, SIGNAL(msgOut(xIrcMessage *)), 
              pSocket, SLOT(sendIrcServerMessage(xIrcMessage *)));
      disconnect(ChanQuery, SIGNAL(ircMessageOut(xIrcMessage*)),
              pSocket, SLOT(sendIrcServerMessage(xIrcMessage*)));
      disconnect(pSocketBox, SIGNAL(stopConnection()),
              this, SLOT(stopConnection()));
/*
      disconnect(pSocket, SIGNAL(connecting(const char *)),
              pSocketBox, SLOT(connectMessage(const char *)));
      disconnect(pSocketBox, SIGNAL(nextConnection()),
              pSocket, SLOT(tryNextConnection()));
*/
      delete pSocket;
      pSocket = NULL;
      Dispatcher.setSocket(pSocket);
      pNotify->shutDown();
      if (dbg) fprintf(stdout, "xIrcConnect::socketClosed():Signals disconnected\n");
      if (dbg) fflush(stdout);
      if (quitFlag)
         pApp->quit();
      else
      {
         sprintf(buf, "***\x02 Connection Closed!!\n");
         pMainWin->pWin->putString(buf);
//         newServer();
      }
      if (dbg) fprintf(stdout, "xIrcConnect::socketClosed():Exit\n");
      if (dbg) fflush(stdout);
};
   
void xIrcConnect::gotChanBoxResult(int result)
{
   xIrcDccChatFrame *pDccChatFrame;
   xIrcMessageFrame *pMsg;
   const char *cp;
   char buf[256];
   int err;
   
   if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Enter\n");
   if (dbg) fflush(stdout);
   if (pSocket == NULL)
   {
      xMessageBox::message("Error", "Not Connected to a Server");
      return;
   }

   if (result == xChannelQuery::Accepted)
   {
      if (findMsgFrame(ChanQuery->editText()) == NULL)
      {
         if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Creating Message Frame\n");
         if (dbg) fflush(stdout);
         if ((pMsg = makeNewMsgFrame(NULL, ChanQuery->editText())) != NULL)
         {
            if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Showing Message Frame\n");
            if (dbg) fflush(stdout);
            pMsg->show();
            if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Getting channel name\n");
            if (dbg) fflush(stdout);
            cp = ChanQuery->editText();
            if (*cp == '#')
            {
               if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Joining channel\n");
               if (dbg) fflush(stdout);
               sprintf(buf, "JOIN %s\n", ChanQuery->editText());
               emit textOut(buf);
            }
         }     
      }
      else
         xMessageBox::message("Error", "Channel already opened");
   }
   else if (result == xChannelQuery::DccChat)
   {
      struct sockaddr_in addr = pSocket->socketName();
      sprintf(buf, "%d", addr.sin_addr.s_addr);
      if ((pDccChatFrame = new xIrcDccChatFrame(wdtPrv, NULL, 
                                                ChanQuery->editText())) != NULL)
      {
         connect(pDccChatFrame, SIGNAL(initiateDCCChat(xIrcDccChatFrame*)),
                 this, SLOT(initiateDCCChat(xIrcDccChatFrame*)));
         if ((err = pDccChatFrame->accept()) == 0)
         {
            connect(pDccChatFrame, SIGNAL(textSelected(xMultiLineTextSelection)),
                    pNickAction, SLOT(wakeUp(xMultiLineTextSelection)));
            pDccChatFrame->show();
         }
         else
         {
            sprintf(buf, "Error Accepting Connection from %s:%s",
                         ChanQuery->editText(), strerror(err));
            xMessageBox::message("Error", buf);
            disconnect(pDccChatFrame, SIGNAL(initiateDCCChat(xIrcDccChatFrame*)),
                       this, SLOT(initiateDCCChat(xIrcDccChatFrame*)));
            delete pDccChatFrame;
         }
      }
   }
   if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcConnect::newChannel()
{
   ChanQuery->show();
}

bool xIrcConnect::isMsg(int cmd, char *pStr)
{
   return(ircResponses.is(cmd, pStr));
}

void xIrcConnect::sendMsgToSocket(const char *pBuf)
{
   emit textOut(pBuf);
}
void xIrcConnect::sendMessage(xIrcMessage *pMsg)
{
   Dispatcher.dispatchMsg(NULL, NULL, pMsg);
}

void xIrcConnect::recvMessage(xIrcMessage *pMsg)
{
   xIrcMessage msgOut;
   
   if (isMsg(pMsg->rspCode, "PING"))
   {
      msgOut.rspCode = ircResponses.code("PONG");
      msgOut.dstStr = "";
      msgOut.msgStr = pMsg->srcAddr;
      if (pSocket != NULL)
         pSocket->sendIrcServerMessage(&msgOut);
   }
   else
      gotResponse(pMsg);
}


void xIrcConnect::showResponse(xIrcMessage *pMsg)
{
   char buf[512];
   
   if (pMsg->rspCode != 0 && 
       !(pMsg->rspCode >= 321 && pMsg->rspCode <= 323) &&
       pMsg->rspCode != 353 && pMsg->rspCode != 366)
      sprintf(buf, "%d::%s", pMsg->rspCode, (const char *)pMsg->msgStr);
   else if (pMsg->rspCode != 0)
      sprintf(buf, "%s: %s", (const char *)pMsg->dstStr,
              (const char *)pMsg->msgStr);
   else
      sprintf(buf, "%s", (const char *)pMsg->rawMsg);
   pMainWin->pWin->putString(buf);
}

void xIrcConnect::showError(xIrcMessage *pMsg)
{
   int rspCode = pMsg->rspCode;
   if (dbg) fprintf(stdout, "xIrcConnect::showError():Enter:pMsg = %d\n", (int)pMsg);
   if (dbg) fflush(stdout);
   if (rspCode == 431 || rspCode == 432 || rspCode == 433)
      gotErrorAck(rspCode);
   else
   {
      xIrcErrorBox *pMB = new xIrcErrorBox(wdtPrv, NULL, "Error", this, 
                                           SLOT(gotErrorAck(int)),
                                           pMsg);
      pMB->show();
   }
   if (dbg) fprintf(stdout, "xIrcConnect::showError():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcConnect::gotErrorAck(int rspCode)
{
   char buf[200];
   const char *cp;
   
   if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Enter: rspCode = %d\n", rspCode);
   if (dbg) fflush(stdout);
   if (rspCode == 431 || rspCode == 432 || rspCode == 433)
   {
      if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Have Nick Problem, are we auto??\n");
      if (dbg) fflush(stdout);
      if (NickQuery->autoSelectNick())
      {
         if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Get Next Nick\n");
         if (dbg) fflush(stdout);
         if ((cp = NickQuery->nextNick()) != NULL)
         {
            if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Got it!\n");
            if (dbg) fflush(stdout);
            sprintf(buf, "NICK %s\n", cp);
            emit textOut(buf);
            NickQuery->setText(cp);
            if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Exit\n");
            if (dbg) fflush(stdout);
            return;
         }
      }
      if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Querying for Nick\n");
      if (dbg) fflush(stdout);
      for (;;)
      {
         NickQuery->exec();
         if (strlen(NickQuery->text()) > 0)
         {
            nickName = NickQuery->text();
            break;
         }
         else
            xMessageBox::message("Error", "You must choose a NickName");
      }
      sprintf(buf, "NICK %s\n", NickQuery->text());
      emit textOut(buf);
   }
   if (dbg) fprintf(stdout, "xIrcConnect::gotErrorAck():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcConnect::keyboardInput()
{
   if (dbg) fprintf(stdout, "xIrcConnect::keyboardInput():Got Enter!!!!\n");
   if (dbg) fflush(stdout);
//   pMainWin->pWin->putString(pEdit->text());
//   pSocket->sendToSocket(pText);
   if (dbg) fprintf(stdout, "xIrcConnect::keyboardInput():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcConnect::resizeEvent(QResizeEvent *pEvt)
{
//   pEvt++;
   QSize sizeFrame, sizeNewFrame, sizeTerm, s;

   if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Enter - %d\n", resizeCnt);
   if (dbg) fflush(stdout);
   if (resizeCnt >= 0)
      resizeCnt++;
//   if (resizeCnt < 2 && resizeCnt >= 0)
   {
      if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Resizing Frame - %d\n", resizeCnt);
      if (dbg) fflush(stdout);
      sizeFrame = pEvt->size();
      sizeTerm = sizeFrame;
      if (resizeCnt >= 0)
      {
         if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Resizing Terminal Frame - %d\n", resizeCnt);
         if (dbg) fflush(stdout);
         sizeTerm.setHeight(sizeFrame.height() - pLabel->size().height());
/*
         sizeTerm.setHeight(sizeFrame.height() - pButtons->size().height());
*/
         pMainWin->resize(sizeTerm);
      }

      s = pLabel->size();
/*
      s = pButtons->size();
*/
      s.setWidth(sizeTerm.width());
      pLabel->resize(s);
/*
      pButtons->resize(&s);
*/

      sizeNewFrame = pMainWin->size();
      sizeNewFrame.setHeight(sizeNewFrame.height() + pLabel->size().height());
/*
      sizeNewFrame.setHeight(sizeNewFrame.height() + pButtons->size().height());
*/
      if (sizeNewFrame != sizeFrame)
      {
         if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Fittinging Frame - %d\n", resizeCnt);
         if (dbg) fflush(stdout);
         resize(&sizeNewFrame);
         initFrame(&sizeNewFrame);
      }
      if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Fittinging Frame - %d\n", resizeCnt);
      if (dbg) fflush(stdout);
      if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Done -  %d\n", resizeCnt);
      if (dbg) fflush(stdout);
   }
//   else if (resizeCnt < 0)
   if (resizeCnt < 0)
      resizeCnt++;
   if (resizeCnt > 0)
      resizeCnt--;
      
   if (dbg) fprintf(stdout, "xIrcConnect::resizeEvent():Exit-  %d\n", resizeCnt);
   if (dbg) fflush(stdout);
}

#include "xIrcConnect.moc"

/*
void xIrcConnect::newServer()
{
   int btn;
   char buf[512];

   if (dbg) fprintf(stdout, "xIrcConnect::newServer():Enter\n");
   if (dbg) fflush(stdout);
   if (dbg) fprintf(stdout, "xIrcConnect::newServer():Executing Query\n");
   if (dbg) fflush(stdout);
   btn = xServerQuery::Accepted;
   if (serverFlag || (btn = ServQuery->exec()) != QDialog::Rejected)
   {
      if (dbg) fprintf(stdout, "xIrcConnect::newServer():btn = %d\n", btn);
      if (dbg) fflush(stdout);
      if (pSocket->isConnected() && (btn == xServerQuery::Disconnect ||
                                      btn == xServerQuery::Accepted))
      {
         if (btn == xServerQuery::Accepted)
         {
            if (dbg) fprintf(stdout, "xIrcConnect::newServer():Disconnecting from Server\n");
            if (dbg) fflush(stdout);
            sprintf(buf, "QUIT :Changing Servers\n");
            emit textOut(buf);
            serverFlag = TRUE;
         }
         else
         {
            serverFlag = FALSE;
            pSocket->disconnectTCP();
         }
      }
      if (btn == xServerQuery::Accepted)
      {
         serverFlag = FALSE;
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():Connecting to xSocket sginals\n");
         if (dbg) fflush(stdout);
         connect(pSocket, SIGNAL(connAccepted(int)),      
                 this, SLOT(goodConnection(int)));
         connect(pSocket, SIGNAL(connFailed(int)),      
                 this, SLOT(failedConnection(int)));
         if (dbg) fprintf(stdout, "xIrcConnect::newServer():calling xSocket::connectTo\n");
         if (dbg) fflush(stdout);
         if (pSocket->connectTo(ServQuery->server(), ServQuery->port()) == FALSE)
         {
            if (dbg) fprintf(stdout, "xIrcConnect::newServer():Got an error\n");
            if (dbg) fflush(stdout);
            disconnect(pSocket, SIGNAL(connAccepted(int)),      
                       this, SLOT(goodConnection(int)));
            disconnect(pSocket, SIGNAL(connFailed(int)),      
                       this, SLOT(failedConnection(int)));
            pSocketBox->hide();
            xMessageBox::message("Error", "Connection Failed");
            if (dbg) fprintf(stdout, "xIrcConnect::newServer():Failed!!!\n");
            if (dbg) fflush(stdout);
            newServer();
         }
         else
         {
            if (dbg) fprintf(stdout, "xIrcConnect::newServer():Returned from connectTo()!!!\n");
            if (dbg) fflush(stdout);
            pSocketBox->show();
         }
      }
   }
   if (dbg) fprintf(stdout, "xIrcConnect::newServer():Exit\n");
   if (dbg) fflush(stdout);
} 
*/

