#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Message.tcl,v $
# $Date: 1996/04/03 13:52:41 $
# $Revision: 1.16.1.18 $
#
set defMsg {}
#
proc Message {name args} {
    if ![string compare :: $name] {
	set op [lindex $args 0]
	if ![string match {} [info procs Message_$op]] {
	    return [eval Message_$op [lrange $args 1 end] ]
	} {
	    return [eval Channel_$op [lrange $args 1 end] ]
	}
    }
    if ![string compare nil [set id [Message :: find $name]]] {
	set id [makeMessage $name]
    }
    if ![string match {} $args] { eval $id configure $args }
    return $id
}
#
proc message_call {this op args} {
    if [string match {} [info procs message_$op]] {
	return [eval channel_call $this $op $args]
    } {
	return [eval message_$op $this $args]
    }
}
#
class Message {
    away {}
}
#
proc makeMessage {chan} {
    global MTO defMsg defChan
    set this [objName Message]
    proc $this {args} "eval message_call $this \$args "
    initObj $this Channel Message
    upvar #0 $this mdata
    User :: make [set lchan [string tolower $chan]]
    if [string match {} [set def $defMsg]] {
	set def $defChan
	set b 0
    } {
	set b [$def buttons]
    }
    array set mdata [uplevel #0 array get $def]
    set mdata(keep) 0
    set mdata(buttons) $b
    set mdata(name) $chan
    set mdata(lname) $lchan
    set MTO($lchan) $this
    return $this
}
#
proc message_delete {this} { mcnDelete $this MTO }
#
proc Message_make {nk args} {
    global MTO
    set nk [string range [cleanup $nk] 0 8]
    set usr [User :: make $nk]
    set ln [string tolower $nk]
    if [info exists MTO($ln)] { set id $MTO($ln) } { set id [Message $nk] }
    $id configure -crypt [$usr crypt]
    $id show -nofocus
    $id addUser $usr 0 0
    if ![string match {} $args] { eval $id configure $args }
    return $id
}
#
proc Message_find {nk} {
    global MTO
    set ln [string tolower $nk]
    return [expr {[info exists MTO($ln)] ? $MTO($ln) : {nil}}]
}
#
proc Message_save {desc} {
    global defMsg
    $defMsg save $desc
    foreach ch [Message :: list] {
	if {$ch != $defMsg && [$ch keep]} { $ch save $desc }
    }
}
#
proc message_save {this desc} {
    global defMsg
    set ln [mncSave $this $desc $defMsg]
    foreach op {draw} {
	if {$this == $defMsg || [$this $op] != [$defMsg $op]} {
	    append ln " -$op [$this $op]"
	}
    }
    foreach op {logfile icon} {
	if ![string match {} [set v [$this $op]]] { append ln " -$op {$v}"	}
    }
    puts $desc $ln
    foreach  b [$this bindings] {
	puts $desc "zbind [$this name] [lindex $b 0] {[lindex $b 1]}"
    }
}
#
proc message_awayMsg {this msg} {
    upvar #0 $this mdata
    if {$mdata(away) != $msg} {
	set mdata(away) $msg
	if [$this active] {
	    $this addText {} "*** [$this name] is away : $msg"
	}
    }
}
