/*
   Time-stamp: <95/12/07 00:52:04 yusuf>
*/


#include "taper.h"

PRIVATE int info_fd;



PRIVATE inline _errstat write_info(_vptr buf, _s32 szbuf, char *lmes)
{
    if (write(info_fd, buf, szbuf) != szbuf) {
	write_error_log(lmes);
	return do_exit(ERROR_WRITING_INFO);
    }
    return 0;
}

PRIVATE _s32 tr, trc;
PRIVATE _errstat mkinfo_action(struct file_info *fi, char *fn, struct oa_file_entry *dummy, _s32 dum_pos)
{
    char l[300];
    _s32  x;
    
    strcpy(l, "Writing filename & file info");
    if (log_level > 2) write_log(l);
    if (write_info(fi, sizeof(*fi), l) == -1) return -1;
    if (write_info(fn, fi->name_len, l) == -1) return -1;
    x = sizeof(*fi)+fi->name_len;
    ifd.info_file_size += x;
    tr += x; trc += x;
    if (S_ISREG(fi->mode)) {
	tr += fi->act_size;
	trc += fi->size;
    }
    
    ifd.no_in_archive++;
    if (fi->checksum == -1) {
	sprintf(l, "There was a problem when backing up file %s, therefore file not restored", fn);
	write_warning_log(l);
    }
    if (fi->checksum == -2) {
	sprintf(l, "Backup was aborted before %s was backed up", fn);
	write_warning_log(l);
    }
    return 0;
}


PRIVATE _s32 file_no;					 /* for cumulative  */
PRIVATE void mkinfo_print_status(WINDOW *mes_box, _s32 cur_in_vol, 
			 _s32 no_in_vol, _s32 vol,
			 _s32 file_size, char *fn,
			 time_t t_start, time_t t_current)
{
    char num1[50], scr[MAXNAMLEN], num2[50];
    _s32 x;
    
    sprintf(scr, "Passing %s", fn);
    status_box(mes_box, scr, 0, FALSE, 1);
    file_no++;
    sprintf(scr, "Volume %d. File %d of %d", vol, cur_in_vol, no_in_vol);
    status_box(mes_box, scr, 2, FALSE, 1);
    sprintf(scr, "Total read: file %d, size %s", file_no, print_kb(num1, tr));
    status_box(mes_box, scr, 3, FALSE, 1);
    sprintf(scr, "Time elapsed %s", convtime(num1, t_start, t_current));
    status_box(mes_box, scr, 5, FALSE, 1);
    x=t_current-t_start;
    if (x) {
	sprintf(scr, "Mkinfo rate %s/min [%s/min]",
		print_mb(num1, tr/x*60),
		print_mb(num2, trc/x*60));
	status_box(mes_box, scr, 7, FALSE, 1);
    }
}


PRIVATE _time_t t_start, t_current;
PRIVATE _errstat mkinfo_loop(file_passed_action action, print_status ps)	 
{
/* This loops through the archive. It calls action for each file
 * in encounters.
 * 
 * We use the non-rewinding device so that when the end of tape is
 * reached, the user doesn't have to wait for the device to rewind
 * before s/he can insert the next tape
 * 
 * Note that for regular files, when moving on to a new volume, then
 * the rest of the data from the block currently read must be discarded
 * because there is no easy was to do a tape_fsf(dv,1) on regular files.
 * 
 * Assumes a rewinding tape device is open and tape header has been read in
 *
 * Returns -1 if an error occurred
 */
    WINDOW *mes_box=NULL;
    _s32  cur_vol, in_vol;
    struct volume_tape_info *vi;
    struct volume_header vh;

    mes_box = status_box(mes_box, "                                               ", 2, TRUE, 5);/* create window */
    nodelay(mes_box, TRUE);
    status_box(mes_box, "Identifying tape", 2, FALSE, 1);
    if (check_tape(mes_box, 2, 1) == -1)	 /* make sure first tape in drive */
      return -1;
    cur_vol = 0;				 
    t_start = time(NULL);
    if (read_volheader(&vh, 1, 1) == -1) return -1;
    ifd.size_volume_headers = vh.size_header;
    while (1) {
	if (traverse_volume(action, vh.no_in_volume, t_start, 
			    mes_box, 1, ps, &in_vol, FALSE) < 0)/* traverse this volume */
	  return -1;				 /* user aborted or error*/
	get_vh(vol_headers, cur_vol+1)->no_in_volume = in_vol;
	cur_vol++;
	vi = vt_info+ifd.number_volumes-1;	 /* update volume/tape info */
	vi->end_tape = tdh.tape_number;
	vi->blocks_on_last_tape = blocks_passed;
	blocks_passed = 0;
	if (have_fsf) {				 /* if a tape device is being */
	    status_box(mes_box, "", 0, FALSE, 1);
	    status_box(mes_box, "", 2, FALSE, 1);
	    status_box(mes_box, "", 5, FALSE, 1);
	    status_box(mes_box, "", 6, FALSE, 1);
	    status_box(mes_box, "Looking for next volume", 3, FALSE, 1);
	    if (fast_fsf) {
		if (log_level > 2) write_log("Doing a fast FSF");
		if (tape_fsf(1) == -1)		 /* unable */
		  break;			 /* assume EOT */
		read_offset = -1;
	    }
	    else {				 /* slow fsf */
		tape_close();			 /* reposition tape */
	    					 /* should rewind since we expect a rewinding to be open */
		if (ntape_open(O_RDONLY) == -1) {/* it's a pity that we have to rewind */
		    write_fatal_log("Opening non-rewinding device to do fsf");
		    return -1;
		}
		vols_passed++;			 /* passed another vol on this tape */
		if (tape_fsf(vols_passed) == -1) /* couldn't fsf - assume end of data */
		    break;
		tape_close(dv);		
		if (tape_open(O_RDONLY) == -1) {/* open rewinding */
		    write_fatal_log("Reopening device after repositioning");
		    return -1;
		}
	    }
	}
	else {
	    if (log_level > 2) write_log("Simulating fsf by discarding rest of block");
	    read_offset = -1;
	}
    
	if (tape_read(&vh, sizeof(struct volume_header)) != sizeof(struct volume_header))   /* read in magic */
	  break;				 /* couldn't read - assume eot */
	if (vh.volume_magic != VOLUME_MAGIC) /* not magic */
	  break;				 /* therefore assume eot */
	if (vh.no_in_volume == -1) {	 /* volumes subsequently have been deleted */
	    if (log_level > 2) write_log("Previously erased volumes detected");
	    break;
	}
	ifd.number_volumes++;
	vt_info = my_realloc(vt_info, sizeof(struct volume_tape_info)*ifd.number_volumes);
	vi = vt_info+ifd.number_volumes-1;	 /* update volume/tape info */
	vi->volume = ifd.number_volumes;
	vi->start_tape = tdh.tape_number;
	if (read_volheader(&vh, 0, 1) == -1)
	  return -1;
	ifd.size_volume_headers += vh.size_header; /* update size of volume headers */
    }
    
    ifd.number_tapes = tdh.tape_number;
    nodelay(mes_box, FALSE);
    close_statusbox(mes_box);
    return 0;
}


PRIVATE _errstat recreate() 
{
    WINDOW *mes_box=NULL;

    file_no=0;
    tr = 0; trc = 0;
    mes_box = status_box(mes_box, "Rewinding tape", 2, TRUE, 4);/* create window */
    if (tape_rewind(0) == -1) return -1;
    status_box(mes_box, "Identifying tape", 2, FALSE, 1);
    if (tape_open(O_RDWR) == -1)		 /* open rewinding device */
      return -1;
    blocks_passed = 0;
    if (tape_readheader(&tdh, 0) == -1) 
      return -1;
    if (tdh.magic != TAPER_MAGIC_NUMBER) {
	if (tdh.magic == TAPER_4_MAGIC_NUMBER)
	  message_box("Sorry, taper 4 archives are not compatible", MB_OK);
	return do_exit(ERROR_MAGIC);
    }

    memset(&ifd, 0, sizeof(ifd));		 /* clear all variables */
    ifd.archive_id = tdh.archive_id;
    strcpy(ifd.archive_title, tdh.archive_title);
    ifd.number_tapes = 1;
    ifd.info_file_size = sizeof(ifd);
    ifd.no_in_archive = 0;
    ifd.number_volumes = 1;
    print_title_line();				 /* refresh title line */
    if ((info_fd = open_info_file(FALSE, tdh.archive_id)) == -1) return -1;
    vt_info = my_realloc(vt_info, sizeof(struct volume_tape_info));
    vt_info->volume = 1;			 /* first volume always on tape 1 */
    vt_info->start_tape = 1;

    if (write_info(&ifd, sizeof(ifd), "Writing info file header") == -1)
      return do_exit(ERROR_WRITING_INFO);

    if (mkinfo_loop(mkinfo_action, mkinfo_print_status) == -1) {
	if (log_level > 2) write_log("Mkinfo loop returned an error");
	close(info_fd);
	return -1;   
    }
    status_box(mes_box, "Closing & Rewinding tape", 2, FALSE, 1);
    if (log_level > 2) write_log("Writing volume header information");
    if (write(info_fd, vol_headers, ifd.size_volume_headers) == -1) 
      return do_exit(ERROR_WRITING_INFO);
    if (log_level > 2) write_log("Writing VT information");
    if (write(info_fd, vt_info, sizeof(struct volume_tape_info)*ifd.number_volumes) == -1)
      return do_exit(ERROR_WRITING_INFO);

    if (log_level > 2) write_log("Rewinding and writing header information");
    lseek(info_fd, 0, SEEK_SET);		 /* update info file */
    if (write_info(&ifd, sizeof(ifd), "Updating info file header") == -1)
      return do_exit(ERROR_WRITING_INFO);
    if (log_level > 2) write_log("Closing info file");
    close(info_fd);				 /* close info file */
    return 0;
}

    
PRIVATE _errstat mkinfo_do_mallocs()
{
    vt_info = my_malloc(1);
    vol_headers = my_malloc(sizeof(_s32));
    if ((vt_info == NULL) || (vol_headers == NULL)) return -1;
    return 0;
}


PRIVATE void mkinfo_free_memory()
{
    my_free(vt_info);
    my_free(vol_headers);
}


void taper_mkinfo()
{
    _s32   x;
    char  sa[9][150];
    char  s2[30], s3[30];
    if (!message_box("Insert tape in drive", MB_OKCANCEL))
      return;
    if (mkinfo_do_mallocs() == -1) return;
    if (open_logfile("Mkinfo") == -1) return;
    if (check_device_names() == -1) return;	 /* check devices & other parms */
    recreate(); 
    touchwin(win_main); wrefresh(win_main);
    t_current = time(NULL);
    x = t_current - t_start;
    if (x==0) x=1;
    sprintf(sa[0], "Mkinfo/Check archive finished");
    strcpy(sa[1], "");
    sprintf(sa[2], "Found: %d files in  %d volumes, ", ifd.no_in_archive,
	    ifd.number_volumes);
    if (log_level > 1) write_log(sa[2]);
    sprintf(sa[3], "Total on archive %s [%s]. Ratio %.2f", 
	    print_mb(s2, tr),
	    print_mb(s3, trc),
	    (tr == 0) ? 1 : (float) trc / (float) tr);
    if (log_level > 1) write_log(sa[3]);
    strcpy(sa[4], "");
    sprintf(sa[5], "Time elapsed %s.", convtime(s2, t_start, t_current));
    if (log_level > 1) write_log(sa[5]);

    sprintf(sa[6], "Mkinfo rate %s/min [%s/min]", 
	    print_mb(s2, tr/x*60),
	    print_mb(s3, trc/x*60));
    if (log_level > 1) write_log(sa[6]);
    strcpy(sa[7], "");
    sprintf(sa[8], "%d warnings, %d errors", log_warnings, log_errors);
    if (log_level > 1) write_log(sa[8]);
    multi_message_box(sa, 9, MB_OK);
    tape_close();
    mkinfo_free_memory();
    close_logfile("Mkinfo");
    return;			                 /* succesful return */
}
