/*
 * dlsof.h - PTX header file for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.5 96/01/09 08:18:59 abe Exp $
 */


#if	!defined(PTX_LSOF_H)
#define	PTX_LSOF_H	1

#include <dirent.h>
#include <fcntl.h>
#include <mntent.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <nlist.h>
#include <sys/flock.h>
#include <sys/time.h>
#include <sys/vm.h>

# if	_PTXV>=400
#include <sys/cred.h>
#include <sys/vm_as.h>
# else	/* _PTXV<400 */
#include <sys/swap.h>
# endif	/* _PTXV>=400 */

#include <sys/vnode.h>
#include <sys/procstats.h>
#include <sys/proc.h>
#include <sys/session.h>
#include <sys/socket.h>
#undef	AF_OSINET
#include <sys/socketvar.h>
#include <sys/snode.h>
#include <sys/sysmacros.h>
#include <sys/swap.h>
#include <sys/un.h>
#include <sys/var.h>
#include <sys/vfs.h>
#include <sys/ufsmount.h>
#include <netinet/in.h>

# if	defined(HAS_NFS)
#include <nfs/nfs.h>
#include <nfs/nfs_clnt.h>

#  if	_PTXV<400
#include <nfs/rnode.h>
#  else	/* _PTXV>=400 */
#include "/usr/conf/uts/nfs/rnode.h"
#  endif	/* _PTXV<400 */
# endif	/* defined(HAS_NFS) */

# if	_PTXV<400
#define _INKERNEL
# endif	/* _PTXV<400 */

# if	defined(HAS_CDFS)

#  if	_PTXV>=400
#define _INKERNEL
#  endif	/* _PTXV>=400 */

#include <sys/cdfsinode.h>
#undef	IUPD
#undef	IACC
#undef	ICHG
#undef	IFREE
#undef	IFMT
#undef	IFREG
#undef	IFBLK
#undef	IFCHR
#undef	IFDIR
#undef	IREAD
#undef	IWRITE
#undef	IEXEC
#undef	VTOI
#undef	i_number
#undef	i_mutex
#undef	i_devvp
#undef	i_dev

#  if	_PTXV>=400
#undef _INKERNEL
#  endif	/* _PTXV>=400 */
# endif	/* defined(HAS_CDFS) */

#include <sys/fifonode.h>
#include <sys/file.h>

# if	_PTXV>=400
#define	_INKERNEL	1
#include <sys/namenode.h>
#undef	_INKERNEL
# endif	/* _PTXV>=400 */

#include <sys/stream.h>
#include <sys/tiuser.h>
#include <sys/sockmod.h>
#include <sys/ufsinode.h>
#undef	i_size
#include <sys/user.h>

# if	_PTXV<400
#undef _INKERNEL
# endif	/* _PTXV<400 */

#include <netinet/in_pcb.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_var.h>


#define	COMP_P		const void
#define QSORT_P		void

#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	void
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define	MOUNTED		MNTTABNAME

# if	defined(HASNCACHE)
#define	NC_SIZE		128	/* should come from a header file */
# endif	/* defined(HASNCACHE) */

#define N_UNIX		"/unix"
#define	READLEN_T	size_t
#define STRNCPY_L	size_t
#define SWAP		"/dev/swap"
#define	U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

struct clone {
	int dx;				/* index of device entry in Devtp[] */
	struct clone *next;		/* forward link */
};
extern struct clone *Clone;

extern int CloneMajor;			/* clone major device number */
extern int HaveCloneMajor;		/* CloneMajor status */
extern int Kmem;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};


/*
 * Name list (Nl[]) indexes
 */

#define X_ASOPSLARGE	0
#define X_ASOPSSMALL	1
#define	X_CDFSOPS	2
#define	X_CLONEMAJ	3
#define	X_FIFOOPS	4
#define	X_NCACHE	5
#define	X_NCSIZE	6
#define X_NFSOPS	7
#define	X_NMOPS		8
#define	X_NOFILE	9
#define X_PROC          10
#define	X_SPECOPS	11
#define	X_VAR		12

extern int Notkmem;

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	mode_t mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

extern int Swap;

#endif	/* PTX_LSOF_H */
