/*
 * dlsof.h - Linux header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.13 96/01/09 08:18:26 abe Exp $
 */


#if	!defined(LINUX_LSOF_H)
#define	LINUX_LSOF_H	1

#include <dirent.h>
#include <fcntl.h>
#include <malloc.h>
#include <mntent.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <unistd.h>

# if	LINUXV>=1147
#define	__KERNEL__	1
#undef	INT_MAX
#undef	UINT_MAX
#undef	LONG_MAX
#undef	ULONG_MAX
# endif	/* LINUXV>=1147 */

# include <linux/socket.h>
#include <linux/net.h>
#include <linux/in.h>
#include <linux/fs.h>
#include <linux/tasks.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/unistd.h>

#define	get_kernel_syms(addr)	syscall(__NR_get_kernel_syms, (addr))

# if	LINUXV<1147
#define	PWD	pwd
#define	ROOT	root
# else	/* LINUXV>=1147 */
#define	PWD	fs->pwd
#define	ROOT	fs->root
# endif	/* LINUXV<1147 */

#include <linux/mm.h>

# if	LINUXV<1147
#include <linux/ddi.h>
# endif	/* LINUXV<1147 */

# if	defined(HASNETDEVICE_H)
#include <linux/netdevice.h>
# endif	/* defined(HASNETDEVICE_H) */

# if	LINUXV<1300
#include <net/inet/sock.h>
# else	/* LINUXV>=1300 */
#include <net/sock.h>
# endif	/* LINUXV<1300 */

#include <sys/un.h>

# if	LINUXV<1300
#include <net/unix/unix.h>
# endif	/* LINUXV<1300 */

#include <netinet/protocols.h>
#define	IPPROTO_TCP	IP_TCP
#define	IPPROTO_UDP	IP_UDP
#define	IPPROTO_ICMP	IP_ICMP
#define	IPPROTO_IGMP	IP_IGMP
#define	IPPROTO_GGP	IP_GGP
#define	IPPROTO_EGP	IP_EGP
#define	IPPROTO_PUP	IP_PUP
#define	IPPROTO_IDP	IP_XNS_IDP
#define	IPPROTO_ND	IP_SUN_ND

#include <sys/sysmacros.h>


#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */
#define	FSNAMEL		4
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"

# if	!defined(N_UNIXV)
#define N_UNIXV		/zSystem.map
# endif	/* !defined(N_UNIXV) */

#define	N_UNIX_TMP(x)	#x
#define	N_UNIX_STR(x)	N_UNIX_TMP(x)
#define	N_UNIX		N_UNIX_STR(N_UNIXV)

#define MALLOC_P	void
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define QSORT_P		void
#define	READLEN_T	size_t
#define STRNCPY_L	size_t
#define	STRNML		32


/*
 * Global storage definitions (including their structure definitions)
 */

extern int Kmem;

struct nlist {
	char *n_name;			/* kernel symbol name */
	int n_type;			/* type: 0 = defined, 1 = undefined */
	unsigned long n_value;		/* address value */
};

#define X_INPOPS	0
#define	X_LEVEL1	1
#define	X_LEVEL2	2
#define	X_NFSDOPS	3
#define	X_NFSFOPS	4
#define	X_NFSKNC	5
#define	X_NFSYOPS	6
#define X_RDPOPS	7
#define	X_TASK		8
#define X_UXPOPS	9
#define X_WRPOPS	10

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	umode_t mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

#endif	/* LINUX_LSOF_H	*/
