

/*
 * $Id: isfn.frag,v 1.5 96/01/09 08:27:40 abe Exp $
 */


/*
 * is_file_named() - is this file named?
 */

int
is_file_named(p, ty)
	char *p;			/* path name; NULL = search by device
					 * and inode (from *Lf) */
	enum vtype ty;			/* vnode type */
{
	int f;
	struct sfile *s;
/*
 * Search the file chain.
 */
	for (f = 0, s = Sfile; s; s = s->next) {

	/*
	 * Search by path name, as requested.
	 */
		if (p != NULL) {
			if (strcmp(p, s->aname) == 0
			||  strcmp(p, s->name)  == 0)
			{
				f = 2;
				break;
			}
			continue;
		}
	/*
	 * Check for a regular file or directory -- the device and
	 * inode numbers must match.
	 */
		if (s->type) {
			if (Lf->dev == s->dev && (ino_t)Lf->inode == s->i) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a file system match.
	 * Try to avoid matching character files to non-character devices.
	 */
		if (Lf->dev == s->dev) {
			if ( ! (ty == VCHR && s->mode != S_IFCHR)) {
				f = 1;
				break;
			}
		}
	}
/*
 * Convert the name if a match occurred.
 */
	if (f) {
		if (f == 2)
			(void) strcpy(Namech, p);
		else {
			(void) strcpy(Namech, s->name);
			if (s->devnm)
				(void) sprintf(endnm(), " (%s)", s->devnm);
		}
		s->f = 1;
		return(1);
	}
	return(0);
}
