.\" t
.\" @(#)fvwm.1	1/12/94
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.ta .3i .6i .9i 1.2i 1.5i 1.8i
.TH FvwmScript 3.0
.UC
.SH NAME
FvwmScript - module to build graphic user interface
.SH SYNOPSIS
FvwmScript must be spawned by Fvwm.  
It will not work from the command line.
.SH DESCRIPTION
FvwmScript is a module which allows to build many graphical
applications such as desktop accessories, button panel with popup
menu, modal dialog... At the startup, FvwmScript reads
the file which is specified in the command line. This file contains the script.
This script is not included in the configuration file of Fvwm.

.SH INVOCATION
FvwmScript can be invoked by inserting the line `Module
FvwmScript path_and_name_of_script' in the .fvwmrc file.
This can be placed on a line by itself, if FvwmButtons is to be spawned during
fvwm's initialization, or can be bound to a menu or mouse
button or keystroke to invoke it later. Fvwm will search
directory specified in the ModulePath configuration option
to attempt to locate FvwmScript.

Be sure to set ModulePath in your .fvwmrc file to include FvwmScript's path.
.SH ANATOMY OF A SCRIPT
FvwmScript uses a particular programming langage. A script is composed of two 
parts. Heading contains general characteristics of the window and default properties
for all widgets. The second part contains the desciption of widgets. 
A widget consists of eleven types of items: text labels, single-line text inputs,
radio buttons, checkbox, push buttons, horizontal and vertical scrollbars, rectangles,
popup-menus, swallowexecs and mini scrollbars.
.SH HEADING OF A SCRIPT
The syntax is as follows:

.IP "WindowSize \fIwidth height\fP"
This option sets window size. \fIwidth\fP and \fIheight\fP are numerical value.

.IP "WindowPosition \fIx y\fP"
This option sets window position. \fIx\fP and \fIy\fP are numerical value.

.IP "ForeColor {\fIcolor\fP}"
This option sets the default foreground color for all widgets.

.IP "BackColor {\fIcolor\fP}"
This option sets the default background color for all widgets.

.IP "HilightColor {\fIcolor\fP}"
This option sets the default hilight color for all widgets.

.IP "ShadowColor {\fIcolor\fP}"
This option sets the default shadow color for all widgets.

.IP "Font {\fIfont\fP}"
This option sets the default font color for all widgets.

Heading	also contains instructions which will be executed at the startup.
For example:
.EX
Init
 Begin
  Do "Exec cat tada.voc > /dev/dsp"
  WarpPointer 1
  Set $ToDo=Restart
 End
.EE
These instructions are used to play a sound, move the pointer 
to widget 1 and to initialize $ToDo to "Restart" at every startup.

.SH MAIN OF A SCRIPT
The second part of the script contains the description for every widget
which will be used in the program.  A description of widget is composed of
two parts. Fisrt part describes initial properties and second part contains
instructions which will be executed when the widget receives  messages.
All widgets can send and receive messages. All message are identify by
a number. The message "UserAction" is sent to a widget when user has
altered this one. The syntax is as following:
.EX
Widget		id	# Set the id widget
Property
 Type		string
 Size width	height
 Position 	x y
 Title		{ string }
 Value		int
 MaxValue 	int
 MinValue 	int
 Font		string
 ForeColor 	{ color }
 BackColor 	{ color }
 HilightColor	{ color }
 ShadowColor	{ Color }

Main
 Case Message of
  UserAction:
  Begin
   # list of instructions which will be
   # executed when widget receives
   # message "UserAction"
  End
  1:
  Begin
   # list of instructions which will be
   # executed when widget receives
   # message 1
  End
 End
.EE

.SH LIST OF WIDGETS
There is eleven types of widgets.

.IP "\fBItemDraw\fP: Display an icon and/or a string."

\fBTitle\fP: string to display.

\fBIcon\fP: icon to display.

.IP "\fBPushButton\fP: Display push button with an icon and/or a string."

\fBTitle\fP: this string has the following syntax {Title of the button|Option 1|Option 2|
Option3|...|Option N}. "Option 1|Option 2|...|Option N" is the popup menu which is
displayed when pressing the right button.

\fBIcon\fP: icon to display.

.IP "\fBRadioButton\fP: Display radio button with a string."

\fBTitle\fP: title of the radio button.

\fBValue\fP: if Value is equal to 1, the box is checked else it is not.

.IP "\fBCheckBox\fP: Display check box with a string."

\fBTitle\fP: title of the check box.

\fBValue\fP: if Value is equal to 1, the box is checked else it is not.

.IP "\fBTextField\fP: Display a text input field. The text input field can be used to edit a single-line string."

\fBTitle\fP: content of text field.

\fBValue\fP: position of the insert point.

.IP "\fBHScrollBar\fP: Display an horizontal scrollbar."

\fBValue\fP: position of the thumb.

\fBMaxValue\fP: upper limit of Value.

\fBMinValue\fP: lower limit of Value.

.IP "\fBVScrollBar\fP: Display a vertical scrollbar."

\fBValue\fP: position of the thumb.

\fBMaxValue\fP: upper limit of Value.

\fBMinValue\fP: lower limit of Value.

.IP "\fBMiniScrollBar\fP: Display a very small vertical scrollbar."

\fBValue\fP: position of the thumb.

\fBMaxValue\fP: upper limit of Value.

\fBMinValue\fP: lower limit of Value.

.IP "\fBRectangle\fP: Display a rectangle. This type of widget can be used to decorate window."

.IP "\fBSwallowExec\fP: This type of widget causes FvwmScript to spawn an process, and capture the first window whose name or resource is equal to Title, and display it in the script window."

\fBTitle\fP: specify the window name which be captured and displayed in the script window.
 
\fBSwallowExec\fP: specify the command line to execute to spawn the process. Modules canalso be swallowed.

\fBValue\fP: specify the looking of the border. Possible value: -1, 0, 1.

.IP "\fBPopupMenu\fP: Display a popup menu."

\fBValue\fP: specify what option is selected.

\fBTitle\fP: the title has the following syntax: {Option 1|Option 2|...|Option N}."Option 1|Option 2|...|Option N" is the popup menu which is displayed when pressing mouse button.

.SH INSTRUCTIONS

Here is the description of all instructions.

.IP "HideWidget \fIid\fP : hide the widget numbered \fIid\fP."

.IP "ShowWidget \fIid\fP: show the widget numbered \fIid\fP."

.IP "ChangeValue \fIid1 id2\fP: set the value of the widget numbered \fIid1\fP to \fIid2\fP."

.IP "ChangeMaxValue \fIid1 id2\fP: set the maximal value of the widget numbered \fIid1\fP to \fIid2\fP."

.IP "ChangeTitle \fIid1 id2\fP: set the title of the widget numbered \fIid1\fP to \fIid2\fP."

.IP "ChangeForeColor \fIid1\fP {\fIcolor\fP}: set the foreground color of the widget numbered \fIid1\fP to {\fIcolor\fP}."

.IP "ChangeBackColor \fIid1\fP {\fIcolor\fP}: set the background color of the widget numbered \fIid1\fP to {\fIcolor\fP}.

.IP "ChangePosition \fIid1 x y\fP: move the widget numbered \fIid1\fP to position (\fIx\fP,\fIy\fP)."

.IP "ChangeSize \fIid1 width height\fP: set the size of the widget numbered \fIid1\fP to (\fIwidth\fP,\fIheight\fP)."

.IP "ChangeFont \fIid1 newfont\fP: set the font of the widget numbered \fIid1\fP to \fInewfont\fP."

.IP "WarpPointer \fIid\fP: warp the mouse pointer into the widget numbered \fIid\fP."

.IP "WriteToFile \fIfilename\fP {\fIstr1\fP} {\fIstr2\fP} etc: write to file "filename" the string which is the concatenation of all arguments \fIstr1\fP, \fIstr2\fP, etc."

.IP "Do {\fIstr1\fP} {\fIstr2\fP} etc: execute the command which is the concatenation of all arguments \fIstr1\fP, \fIstr2\fP, etc."

.IP "Set $\fIvar\fP={\fIstr\fP1} {\fIstr2\fP} etc: concatenate all arguments to a string and set the variable $\fIvar\fP to this string."

.IP "Quit: quit the program."

.IP "SendMessage \fIid1 id2\fP: send a message numbered \fIid2\fP to widget \fIid1\fP."
.SH ARGUMENTS
Most of commands use arguments. There is two kinds of argument: numbers and strings.
A numerical argument is a value which is between -32000 and +32000. A string is always
surrounded with brace. Variables always begin with the character "$" and can contains both
number and string. 

.SH FUNCTIONS
All functions are used as argument. Functions can return both string and number.
The syntax is:
.EX
(function argument1 argument2 etc)
.EE
Here is the complete list of arguments:

.IP "(GetTitle \fIid\fP): return the title of the widget numbered \fIid\fP."

.IP "(GetValue \fIid\fP): return the current value of the widget numbered \fIid\fP."

.IP "(GetOutput {\fIstr\fP} \fIint1 int2\fP): executes the command \fIstr\fP, gets the standart output and returns the word which is in the line \fIint1\fP and in the position \fIint2\fP. If \fIint2\fP is equal to -1, GetOutput returns the complete line."

.IP "(NumToHex \fIint\fP): return the hexadecimal value of \fIint\fP."

.IP "(HexToNum {\fIstr\fP}): return the decimal value of \fIstr\fP, \fIstr\fP must be an hexadecimal value."

.IP "(Add \fIint1 int2\fP): return the result of (\fIint1\fP+\fIint2\fP)."

.IP "(Mult \fIint1 int2\fP): return the result of (\fIint1\fP*\fIint2\fP)."

.IP "(Div \fIint1 int2\fP): return the result of (\fIint1\fP/\fIint2\fP)."

.SH CONDITIONAL LOOPS
There is three kind of conditional loops. The instruction "If-Then-Else" has the following syntax:
.EX
If $ToDo=={Open xcalc} Then
Begin
 Do {Exec xcalc &} 	 		# List of instructions
End
Else
Begin
 Do {Exec killall xcalc &} 	# List of instructions
End
.EE
The second part "Else-Begin-End" is optional. The instruction "While-Do" as the following syntax:
.EX
While $i<5 Do
Begin
 Set $i=(Add i 1)	 		# List of instructions
End
.EE
Two strings can be compared with "==" and two numbers can be compared with "<", "<=", "==", ">=", ">". The loop "For-Do-Begin-End" has the following syntax:
.EX
For $i=1 To 20 Do
Begin
 Do {Exec xcalc &}			# List of instructions
End
.EE
.SH AUTHOR
       Frederic Cordier (f-cord96@univ-lyon1.fr).
