/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  resolve.h
 * Purpose: Definitions for implementing a simple DNS name resolver
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Various definitions:
 */
#define MAX_LABEL_LEN	63		/* max. length of labels	*/
#define MAX_NAME_LEN	255		/* max. length of names		*/
#define DNS_UDP_LEN	512		/* max. length of UDP packets	*/
#define DNS_S_PORT	53		/* DNS server UDP port number	*/
#define DNS_C_PORT	2004		/* DNS client UDP port number	*/
#define MAX_NS		4		/* max. number of name servers	*/
#define DNS_TIMEOUT	180		/* 10 seconds timeout		*/
#define DNS_RETRY	3		/* 3 retries max per server	*/



/*
 **************************************************************************
 *
 * DNS type values:
 */
#define DNS_TYPE_A	1		/* host address			*/
#define DNS_TYPE_NS	2		/* authoratative name server	*/
#define DNS_TYPE_MD	3		/* mail destination		*/
#define DNS_TYPE_MF	4		/* mail forwarder		*/
#define DNS_TYPE_CNAME	5		/* canonical name for an alias	*/
#define DNS_TYPE_SOA	6		/* start of a zone of authority	*/
#define DNS_TYPE_MB	7		/* mailbox domain name		*/
#define DNS_TYPE_MG	8		/* mail group member		*/
#define DNS_TYPE_MR	9		/* mail rename domain name	*/
#define DNS_TYPE_NULL	10		/* NULL RR			*/
#define DNS_TYPE_WKS	11		/* well known service		*/
#define DNS_TYPE_PTR	12		/* domain name pointer		*/
#define DNS_TYPE_HINFO	13		/* host information		*/
#define DNS_TYPE_MINFO	14		/* mailbox information		*/
#define DNS_TYPE_MX	15		/* mail exchange		*/
#define DNS_TYPE_TXT	16		/* text strings			*/
#define DNS_TYPE_ALL	255		/* all records			*/



/*
 **************************************************************************
 *
 * DNS class values:
 */
#define DNS_CLASS_IN	1			/* Internet		*/
#define DNS_CLASS_CS	2			/* CSNET (obsolete)	*/
#define DNS_CLASS_CH	3			/* CHAOS		*/
#define DNS_CLASS_HS	4			/* Hesiod		*/
#define DNS_CLASS_ANY	255			/* any class		*/



/*
 **************************************************************************
 *
 * DNS labels are either plain text with a length byte or consist
 * of a reference offset to compress reoccurring data.
 */
#define COMPR_MASK	0xc0		/* mask for compression flags	*/
#define OFFSET_MASK	0x3fff		/* mask for offset		*/



/*
 **************************************************************************
 *
 * DNS packet header
 */
struct dnshdr
{
	unsigned short xid;		/* packet ID			*/
	unsigned short flags;		/* flags			*/
	unsigned short qdcount;		/* query record count		*/
	unsigned short ancount;		/* answer record count		*/
	unsigned short nscount;		/* nameserver record count	*/
	unsigned short arcount;		/* additional record count	*/
};


/* Header flag bit fields */
#define HEADER_QR	0x8000		/* query flag			*/
#define HEADER_OPCODE	0x7800		/* opcode			*/
#define HEADER_AA	0x0400		/* authoratative answer flag	*/
#define HEADER_TC	0x0200		/* packet truncated flag	*/
#define HEADER_RD	0x0100		/* recursion required flag	*/
#define HEADER_RA	0x0080		/* recursion available flag	*/
#define HEADER_Z	0x0070		/* reserved for future use	*/
#define HEADER_RCODE	0x000f		/* response code		*/


/* Header opcode values */
#define OPCODE_QUERY	0x0000		/* standard query		*/
#define OPCODE_IQUERY	0x0800		/* inverse query		*/
#define OPCODE_STATUS	0x1000		/* server status request	*/


/* Header response codes */
#define RCODE_NOERR	0x0000		/* no error			*/
#define RCODE_FORMAT	0x0001		/* format error			*/
#define RCODE_SERVER	0x0002		/* server failure		*/
#define RCODE_NAME	0x0003		/* name error: no domain	*/
#define RCODE_REFUSED	0x0005		/* server refused query		*/



/*
 **************************************************************************
 *
 * DNS resource record layout
 */
struct rr
{
	unsigned short type;		/* record type			*/
	unsigned short class;		/* record class			*/
	unsigned long  ttl;		/* record time to live		*/
	unsigned short rdlength;	/* length of data in record	*/
};



/*
 **************************************************************************
 *
 * Routines in the resolve module which are public only within the ARPA
 * library
 */

/* Initialize the name resolver */
extern int init_resolve(void);
