.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutDeviceGet 3GLUT "3.2" "GLUT" "GLUT"
.SH NAME
glutDeviceGet - retrieves GLUT device information represented by integers. 
.SH SYNTAX
.nf
.LP
int glutDeviceGet(GLenum info);
.fi
.SH ARGUMENTS
.IP \fIinfo\fP 1i
Name of device information to retrieve.
.TP 8
.B GLUT_HAS_KEYBOARD 
Non-zero if a keyboard is available; zero if not available. For most
GLUT implementations, a keyboard can be assumed.
.TP 8
.B GLUT_HAS_MOUSE
Non-zero if a mouse is available; zero if not available. For most GLUT
implementations, a keyboard can be assumed. 
.TP 8
.B GLUT_HAS_SPACEBALL
Non-zero if a Spaceball is available; zero if not available. 
.TP 8
.B GLUT_HAS_DIAL_AND_BUTTON_BOX 
Non-zero if a dial & button box is available; zero if not available. 
.TP 8
.B GLUT_HAS_TABLET 
Non-zero if a tablet is available; zero if not available. 
.TP 8
.B GLUT_NUM_MOUSE_BUTTONS 
Number of buttons supported by the mouse. If no mouse is supported, zero is
returned. 
.TP 8
.B GLUT_NUM_SPACEBALL_BUTTONS 
Number of buttons supported by the Spaceball. If no Spaceball is supported, zero is
returned. 
.TP 8
.B GLUT_NUM_BUTTON_BOX_BUTTONS 
Number of buttons supported by the dial & button box device. If no dials & button
box device is supported, zero is returned. 
.TP 8
.B GLUT_NUM_DIALS 
Number of dials supported by the dial & button box device. If no dials & button
box device is supported, zero is returned. 
.TP 8
.B GLUT_NUM_TABLET_BUTTONS 
Number of buttons supported by the tablet. If no tablet is supported, zero is
returned. 
.SH DESCRIPTION
glutDeviceGet retrieves GLUT device information represented by integers. The info
parameter determines what type of device information to return. Requesting device
information for an invalid GLUT device information name returns negative one.
.SH X IMPLEMENTATION NOTES
The current implementation uses to X Input extension to regonize SGI's Spaceball,
tablet, and dial and button box devices.
.SH SEE ALSO
glutGet, glutKeyboardFunc, glutMouseFunc, glutSpaceballMotion, glutTabletFunc,
glutDialsFunc, glutButtonBoxFunc
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
