'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
.so man.macros
.TH history n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
history \- Manipulate the history list
.SH SYNOPSIS
\fBhistory \fR?\fIoption\fR? ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBhistory\fR command performs one of several operations related to
recently-executed commands recorded in a history list.  Each of
these recorded commands is referred to as an ``event''.  When
specifying an event to the \fBhistory\fR command, the following
forms may be used:
.IP [1]
A number:  if positive, it refers to the event with
that number (all events are numbered starting at 1).  If the number
is negative, it selects an event relative to the current event
(\fB\-1\fR refers to the previous event, \fB\-2\fR to the one before that, and
so on).
.IP [2]
A string:  selects the most recent event that matches the string.
An event is considered to match the string either if the string is
the same as the first characters of the event, or if the string
matches the event in the sense of the \fBstring match\fR command.
.PP
The \fBhistory\fR command can take any of the following forms:
.TP
\fBhistory\fR
Same
as \fBhistory info\fR, described below.
.TP
\fBhistory add\fI command \fR?\fBexec\fR?
Adds the \fIcommand\fR argument to the history list as a new event.  If
\fBexec\fR is specified (or abbreviated) then the command is also
executed and its result is returned.  If \fBexec\fR isn't specified
then an empty string is returned as result.
.TP
\fBhistory change\fI newValue\fR ?\fIevent\fR?
Replaces the value recorded for an event with \fInewValue\fR.  \fIEvent\fR
specifies the event to replace, and
defaults to the \fIcurrent\fR event (not event \fB\-1\fR).  This command
is intended for use in commands that implement new forms of history
substitution and wish to replace the current event (which invokes the
substitution) with the command created through substitution.  The return
value is an empty string.
.TP
\fBhistory event\fR ?\fIevent\fR?
Returns the value of the event given by \fIevent\fR.  \fIEvent\fR
defaults to \fB\-1\fR.  This command causes history revision to occur:
see below for details.
.TP
\fBhistory info \fR?\fIcount\fR?
Returns a formatted string (intended for humans to read) giving
the event number and contents for each of the events in the history
list except the current event.  If \fIcount\fR is specified
then only the most recent \fIcount\fR events are returned.
.TP
\fBhistory keep \fIcount\fR
This command may be used to change the size of the history list to
\fIcount\fR events.  Initially, 20 events are retained in the history
list.  This command returns an empty string.
.TP
\fBhistory nextid\fR
Returns the number of the next event to be recorded
in the history list.  It is useful for things like printing the
event number in command-line prompts.
.TP
\fBhistory redo \fR?\fIevent\fR?
Re-executes the command indicated by \fIevent\fR and return its result.
\fIEvent\fR defaults to \fB\-1\fR.  This command results in history
revision:  see below for details.
.TP
\fBhistory substitute \fIold new \fR?\fIevent\fR?
Retrieves the command given by \fIevent\fR
(\fB\-1\fR by default), replace any occurrences of \fIold\fR by
\fInew\fR in the command (only simple character equality is supported;
no wild cards), execute the resulting command, and return the result
of that execution.  This command results in history
revision:  see below for details.
.TP
\fBhistory words \fIselector\fR ?\fIevent\fR?
Retrieves from the command given by \fIevent\fR (\fB\-1\fR by default)
the words given by \fIselector\fR, and return those words in a string
separated by spaces.  The \fBselector\fR argument has three forms.
If it is a single number then it selects the word given by that
number (\fB0\fR for the command name, \fB1\fR for its first argument,
and so on).  If it consists of two numbers separated by a dash,
then it selects all the arguments between those two.  Otherwise
\fBselector\fR is treated as a pattern; all words matching that
pattern (in the sense of \fBstring match\fR) are returned.  In
the numeric forms \fB$\fR may be used
to select the last word of a command.
For example, suppose the most recent command in the history list is
.RS
.CS
\fBformat  {%s is %d years old} Alice [expr $ageInMonths/12]\fR
.CE
Below are some history commands and the results they would produce:
.DS
.ta 4c
.fi
.UL Command "	"
.UL Result
.nf

\fBhistory words $	[expr $ageInMonths/12]\fR
\fBhistory words 1-2	{%s is %d years  old} Alice\fR
\fBhistory words *a*o*	{%s is %d years old} [expr $ageInMonths/12]\fR
.DE
\fBHistory words\fR results in history revision:  see below for details.
.RE
.SH "HISTORY REVISION"
.PP
The history options \fBevent\fR, \fBredo\fR, \fBsubstitute\fR,
and \fBwords\fR result in ``history revision''.
When one of these options is invoked then the current event
is modified to eliminate the history command and replace it with
the result of the history command.
For example, suppose that the most recent command in the history
list is
.CS
\fBset a [expr $b+2]\fR
.CE
and suppose that the next command invoked is one of the ones on
the left side of the table below.  The command actually recorded in
the history event will be the corresponding one on the right side
of the table.
.ne 1.5c
.DS
.ta 4c
.fi
.UL "Command Typed" "	"
.UL "Command Recorded"
.nf

\fBhistory redo	set a [expr $b+2]\fR
\fBhistory s a b	set b [expr $b+2]\fR
\fBset c [history w 2]	set c [expr $b+2]\fR
.DE
History revision is needed because event specifiers like \fB\-1\fR
are only valid at a particular time:  once more events have been
added to the history list a different event specifier would be
needed.
History revision occurs even when \fBhistory\fR is invoked
indirectly from the current event (e.g. a user types a command
that invokes a Tcl procedure that invokes \fBhistory\fR):  the
top-level command whose execution eventually resulted in a
\fBhistory\fR command is replaced.
If you wish to invoke commands like \fBhistory words\fR without
history revision, you can use \fBhistory event\fR to save the
current history event and then use \fBhistory change\fR to
restore it later.

.SH KEYWORDS
event, history, record, revision
